/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogFile;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogFileChangeType;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFileChange;

public class SVNChangeLogFile
implements SCMChangeLogFile {
    private final String path;
    private final String url;
    private final List<SVNChangeLogFileChange> changes = new ArrayList<SVNChangeLogFileChange>();

    public SVNChangeLogFile addChange(SVNChangeLogFileChange change) {
        this.changes.add(change);
        return this;
    }

    public List<SCMChangeLogFileChangeType> getChangeTypes() {
        return this.changes.stream().map(SVNChangeLogFileChange::getChangeType).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"path", "url"})
    public SVNChangeLogFile(String path, String url) {
        this.path = path;
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public List<SVNChangeLogFileChange> getChanges() {
        return this.changes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNChangeLogFile)) {
            return false;
        }
        SVNChangeLogFile other = (SVNChangeLogFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<SVNChangeLogFileChange> this$changes = this.getChanges();
        List<SVNChangeLogFileChange> other$changes = other.getChanges();
        return !(this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNChangeLogFile;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<SVNChangeLogFileChange> $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        return result;
    }

    public String toString() {
        return "SVNChangeLogFile(path=" + this.getPath() + ", url=" + this.getUrl() + ", changes=" + this.getChanges() + ")";
    }
}

