/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.db;

import javax.sql.DataSource;
import net.nemerosa.ontrack.extension.svn.db.SVNRepositoryDao;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SVNRepositoryJdbcDao
extends AbstractJdbcRepository
implements SVNRepositoryDao {
    @Autowired
    public SVNRepositoryJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Integer findByName(String name) {
        return (Integer)this.getFirstItem("SELECT ID FROM EXT_SVN_REPOSITORY WHERE NAME = :name", this.params("name", name), Integer.class);
    }

    @Override
    public void delete(int id) {
        this.getNamedParameterJdbcTemplate().update("DELETE FROM EXT_SVN_REPOSITORY WHERE ID = :id", (SqlParameterSource)this.params("id", id));
    }

    @Override
    public int create(String name) {
        return this.dbCreate("INSERT INTO EXT_SVN_REPOSITORY (NAME) VALUES (:name)", this.params("name", name));
    }

    @Override
    public int getByName(String name) {
        return (Integer)this.getNamedParameterJdbcTemplate().queryForObject("SELECT ID FROM EXT_SVN_REPOSITORY WHERE NAME = :name", (SqlParameterSource)this.params("name", name), Integer.class);
    }

    @Override
    public int getOrCreateByName(String name) {
        Integer id = this.findByName(name);
        return id != null ? id.intValue() : this.create(name);
    }
}

