/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.db;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import org.tmatesoft.svn.core.SVNURL;

public class SVNRepository {
    private final int id;
    private final SVNConfiguration configuration;
    private final ConfiguredIssueService configuredIssueService;

    public static SVNRepository of(int id, SVNConfiguration configuration, ConfiguredIssueService configuredIssueService) {
        return new SVNRepository(id, configuration, configuredIssueService);
    }

    public String getBranchPattern() {
        return ".*/branches/[^/]+";
    }

    public String getTagPattern() {
        return ".*/tags/[^/]+";
    }

    public String getUrl(String path) {
        return this.configuration.getUrl(path);
    }

    public String getRevisionBrowsingURL(long revision) {
        return this.configuration.getRevisionBrowsingURL(revision);
    }

    public String getPathBrowsingURL(String path) {
        return this.configuration.getPathBrowsingURL(path);
    }

    public String getFileChangeBrowsingURL(String path, long revision) {
        return this.configuration.getFileChangeBrowsingURL(path, revision);
    }

    public SVNURL getRootUrl() {
        return SVNUtils.toURL(this.configuration.getUrl());
    }

    public int getId() {
        return this.id;
    }

    public SVNConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfiguredIssueService getConfiguredIssueService() {
        return this.configuredIssueService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNRepository)) {
            return false;
        }
        SVNRepository other = (SVNRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        SVNConfiguration this$configuration = this.getConfiguration();
        SVNConfiguration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        ConfiguredIssueService this$configuredIssueService = this.getConfiguredIssueService();
        ConfiguredIssueService other$configuredIssueService = other.getConfiguredIssueService();
        return !(this$configuredIssueService == null ? other$configuredIssueService != null : !this$configuredIssueService.equals(other$configuredIssueService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        SVNConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        ConfiguredIssueService $configuredIssueService = this.getConfiguredIssueService();
        result = result * 59 + ($configuredIssueService == null ? 43 : $configuredIssueService.hashCode());
        return result;
    }

    public String toString() {
        return "SVNRepository(id=" + this.getId() + ", configuration=" + this.getConfiguration() + ", configuredIssueService=" + this.getConfiguredIssueService() + ")";
    }

    @ConstructorProperties(value={"id", "configuration", "configuredIssueService"})
    protected SVNRepository(int id, SVNConfiguration configuration, ConfiguredIssueService configuredIssueService) {
        this.id = id;
        this.configuration = configuration;
        this.configuredIssueService = configuredIssueService;
    }
}

