/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.db;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import javax.sql.DataSource;
import net.nemerosa.ontrack.extension.svn.db.SVNIssueRevisionDao;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SVNIssueRevisionJdbcDao
extends AbstractJdbcRepository
implements SVNIssueRevisionDao {
    private static final int ISSUE_KEY_MAX_LENGTH = 20;
    private final Logger logger = LoggerFactory.getLogger(SVNIssueRevisionDao.class);

    @Autowired
    public SVNIssueRevisionJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void link(int repositoryId, long revision, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            this.logger.warn("Cannot insert a null or blank key (revision {})", (Object)revision);
        } else if (key.length() > 20) {
            this.logger.warn("Cannot insert a key longer than {} characters: {} for revision {}", new Object[]{20, key, revision});
        } else {
            this.getNamedParameterJdbcTemplate().update("INSERT INTO EXT_SVN_REVISION_ISSUE (REPOSITORY, REVISION, ISSUE) VALUES (:repository, :revision, :key)", (SqlParameterSource)this.params("revision", revision).addValue("key", (Object)key).addValue("repository", (Object)repositoryId));
        }
    }

    @Override
    public List<String> findIssuesByRevision(int repositoryId, long revision) {
        return this.getNamedParameterJdbcTemplate().queryForList("SELECT ISSUE FROM EXT_SVN_REVISION_ISSUE WHERE REPOSITORY = :repository AND REVISION = :revision ORDER BY ISSUE", (SqlParameterSource)this.params("revision", revision).addValue("repository", (Object)repositoryId), String.class);
    }

    @Override
    public Optional<String> findIssueByKey(int repositoryId, String issueKey) {
        return Optional.ofNullable(this.getFirstItem("SELECT ISSUE FROM EXT_SVN_REVISION_ISSUE WHERE REPOSITORY = :repository AND ISSUE = :issue ORDER BY REVISION LIMIT 1", this.params("repository", repositoryId).addValue("issue", (Object)issueKey), String.class));
    }

    @Override
    public List<Long> findRevisionsByIssue(int repositoryId, String issueKey) {
        return this.getNamedParameterJdbcTemplate().queryForList("SELECT REVISION FROM EXT_SVN_REVISION_ISSUE WHERE REPOSITORY = :repository AND ISSUE = :key ORDER BY REVISION DESC", (SqlParameterSource)this.params("key", issueKey).addValue("repository", (Object)repositoryId), Long.class);
    }

    @Override
    public OptionalLong findLastRevisionByIssue(int repositoryId, String issueKey) {
        Long revision = (Long)this.getFirstItem("SELECT REVISION FROM EXT_SVN_REVISION_ISSUE WHERE REPOSITORY = :repository AND ISSUE = :key ORDER BY REVISION DESC LIMIT 1", this.params("key", issueKey).addValue("repository", (Object)repositoryId), Long.class);
        return this.optionalLong(revision);
    }

    private OptionalLong optionalLong(Long revision) {
        if (revision != null) {
            return OptionalLong.of(revision);
        }
        return OptionalLong.empty();
    }

    @Override
    public OptionalLong findLastRevisionByIssuesAndBranch(int repositoryId, Collection<String> issueKeys, String branch) {
        Long revision = (Long)this.getFirstItem("SELECT RI.REVISION FROM EXT_SVN_REVISION_ISSUE RI INNER JOIN EXT_SVN_REVISION R ON R.REPOSITORY = RI.REPOSITORY AND R.REVISION = RI.REVISION WHERE RI.ISSUE IN (:keys) AND R.BRANCH = :branch ORDER BY RI.REVISION DESC LIMIT 1", this.params("keys", issueKeys).addValue("repository", (Object)repositoryId).addValue("branch", (Object)branch), Long.class);
        return this.optionalLong(revision);
    }
}

