/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.sql.DataSource;
import net.nemerosa.ontrack.extension.svn.db.SVNEventDao;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SVNEventJdbcDao
extends AbstractJdbcRepository
implements SVNEventDao {
    @Autowired
    public SVNEventJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void createCopyEvent(int repositoryId, long revision, String copyFromPath, long copyFromRevision, String copyToPath) {
        this.getNamedParameterJdbcTemplate().update("INSERT INTO EXT_SVN_COPY (REPOSITORY, REVISION, COPYFROMPATH, COPYFROMREVISION, COPYTOPATH) VALUES (:repository, :revision, :copyFromPath, :copyFromRevision, :copyToPath)", (SqlParameterSource)this.params("revision", revision).addValue("repository", (Object)repositoryId).addValue("copyFromPath", (Object)copyFromPath).addValue("copyFromRevision", (Object)copyFromRevision).addValue("copyToPath", (Object)copyToPath));
    }

    @Override
    public void createStopEvent(int repositoryId, long revision, String path) {
        this.getNamedParameterJdbcTemplate().update("INSERT INTO EXT_SVN_STOP (REPOSITORY, REVISION, PATH) VALUES (:repository, :revision, :path)", (SqlParameterSource)this.params("revision", revision).addValue("repository", (Object)repositoryId).addValue("path", (Object)path));
    }

    @Override
    public TCopyEvent getLastCopyEvent(int repositoryId, String path, long revision) {
        return (TCopyEvent)this.getFirstItem("SELECT * FROM EXT_SVN_COPY WHERE REPOSITORY = :repository AND COPYTOPATH = :path AND REVISION <= :revision ORDER BY REVISION DESC LIMIT 1", this.params("path", path).addValue("revision", (Object)revision).addValue("repository", (Object)repositoryId), (rs, rowNum) -> this.toCopyEvent(rs));
    }

    private TCopyEvent toCopyEvent(ResultSet rs) throws SQLException {
        return new TCopyEvent(rs.getInt("repository"), rs.getLong("revision"), rs.getString("copyFromPath"), rs.getLong("copyFromRevision"), rs.getString("copyToPath"));
    }

    @Override
    public SVNLocation getFirstCopyAfter(int repositoryId, SVNLocation location) {
        return (SVNLocation)this.getFirstItem("SELECT * FROM EXT_SVN_COPY WHERE REPOSITORY = :repository AND COPYFROMPATH = :path AND COPYFROMREVISION >= :revision", this.params("path", location.getPath()).addValue("revision", (Object)location.getRevision()).addValue("repository", (Object)repositoryId), (rs, rowNum) -> new SVNLocation(rs.getString("copyToPath"), rs.getLong("revision")));
    }

    @Override
    public List<TCopyEvent> findCopies(int repositoryId, String fromPath, String toPathPrefix, Predicate<TCopyEvent> filter) {
        return (List)this.getNamedParameterJdbcTemplate().execute("SELECT * FROM EXT_SVN_COPY WHERE REPOSITORY = :repositoryId AND COPYFROMPATH = :fromPath AND COPYTOPATH LIKE :toPath ORDER BY REVISION ASC", (SqlParameterSource)this.params("repositoryId", repositoryId).addValue("fromPath", (Object)fromPath).addValue("toPath", (Object)(toPathPrefix + "%")), ps -> {
            ResultSet rs = ps.executeQuery();
            ArrayList<TCopyEvent> events = new ArrayList<TCopyEvent>();
            while (rs.next()) {
                TCopyEvent event = this.toCopyEvent(rs);
                if (!filter.test(event)) continue;
                events.add(event);
            }
            return events;
        });
    }
}

