/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.common.Utils;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogFileChangeType;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.client.SVNClientException;
import net.nemerosa.ontrack.extension.svn.client.SVNClientLogger;
import net.nemerosa.ontrack.extension.svn.client.SVNSession;
import net.nemerosa.ontrack.extension.svn.client.SVNSessionImpl;
import net.nemerosa.ontrack.extension.svn.db.SVNEventDao;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.model.SVNHistory;
import net.nemerosa.ontrack.extension.svn.model.SVNReference;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionPath;
import net.nemerosa.ontrack.extension.svn.support.SVNLogEntryCollector;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.support.EnvService;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNDebugLog;

@Component
public class SVNClientImpl
implements SVNClient {
    public static final int HISTORY_MAX_DEPTH = 6;
    private final Logger logger = LoggerFactory.getLogger(SVNClient.class);
    private final SVNEventDao svnEventDao;
    private final TransactionService transactionService;
    private final Pattern pathWithRevision = Pattern.compile("(.*)@(\\d+)$");

    @Autowired
    public SVNClientImpl(SVNEventDao svnEventDao, EnvService envService, TransactionService transactionService) {
        this.svnEventDao = svnEventDao;
        this.transactionService = transactionService;
        File spoolDirectory = envService.getWorkingDir("svn", "spooling");
        this.logger.info("[svn] Using Spooling directory at {}", (Object)spoolDirectory.getAbsolutePath());
        SVNDebugLog.setDefaultLog((ISVNDebugLog)new SVNClientLogger());
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(spoolDirectory, true, null));
    }

    @Override
    public boolean exists(SVNRepository repository, SVNURL url, SVNRevision revision) {
        try {
            SVNInfo info = this.getWCClient(repository).doInfo(url, revision, revision);
            return info != null;
        }
        catch (SVNException ex) {
            return false;
        }
    }

    @Override
    public long getRepositoryRevision(SVNRepository repository, SVNURL url) {
        try {
            SVNInfo info = this.getWCClient(repository).doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
            return info.getCommittedRevision().getNumber();
        }
        catch (SVNException e) {
            throw this.translateSVNException(e);
        }
    }

    @Override
    public void log(SVNRepository repository, SVNURL url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision stopRevision, boolean stopOnCopy, boolean discoverChangedPaths, long limit, boolean includeMergedRevisions, ISVNLogEntryHandler isvnLogEntryHandler) {
        try {
            this.getLogClient(repository).doLog(url, null, pegRevision, startRevision, stopRevision, stopOnCopy, discoverChangedPaths, includeMergedRevisions, limit, null, isvnLogEntryHandler);
        }
        catch (SVNException e) {
            throw this.translateSVNException(e);
        }
    }

    @Override
    public List<Long> getMergedRevisions(SVNRepository repository, SVNURL url, long revision) {
        SVNRevision rm1 = SVNRevision.create((long)(revision - 1L));
        SVNRevision r = SVNRevision.create((long)revision);
        boolean existRM1 = this.exists(repository, url, rm1);
        boolean existR = this.exists(repository, url, r);
        try {
            if (existRM1 && existR) {
                HashMap<SVNURL, SVNMergeRangeList> change;
                SVNDiffClient diffClient = this.getDiffClient(repository);
                Map before = diffClient.doGetMergedMergeInfo(url, rm1);
                HashMap<SVNURL, SVNMergeRangeList> after = diffClient.doGetMergedMergeInfo(url, r);
                if (after != null && before != null) {
                    change = new HashMap<SVNURL, SVNMergeRangeList>();
                    for (Map.Entry entry : after.entrySet()) {
                        SVNURL source = (SVNURL)entry.getKey();
                        SVNMergeRangeList afterMergeRangeList = (SVNMergeRangeList)entry.getValue();
                        SVNMergeRangeList beforeMergeRangeList = (SVNMergeRangeList)before.get(source);
                        if (beforeMergeRangeList != null) {
                            SVNMergeRangeList changeRangeList = afterMergeRangeList.diff(beforeMergeRangeList, false);
                            if (changeRangeList.isEmpty()) continue;
                            change.put(source, changeRangeList);
                            continue;
                        }
                        change.put(source, afterMergeRangeList);
                    }
                } else {
                    change = after;
                }
                if (change == null || change.isEmpty()) {
                    return Collections.emptyList();
                }
                SVNLogEntryCollector collector = new SVNLogEntryCollector();
                for (Map.Entry entry : change.entrySet()) {
                    SVNMergeRange[] mergeRanges;
                    SVNURL source = (SVNURL)entry.getKey();
                    SVNMergeRangeList mergeRangeList = (SVNMergeRangeList)entry.getValue();
                    for (SVNMergeRange mergeRange : mergeRanges = mergeRangeList.getRanges()) {
                        SVNRevision endRevision = SVNRevision.create((long)mergeRange.getEndRevision());
                        SVNRevision startRevision = SVNRevision.create((long)mergeRange.getStartRevision());
                        this.log(repository, source, endRevision, startRevision, endRevision, true, false, 0L, false, collector);
                    }
                }
                return collector.getEntries().stream().map(SVNLogEntry::getRevision).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (SVNException ex) {
            throw this.translateSVNException(ex);
        }
    }

    @Override
    public SVNHistory getHistory(SVNRepository repository, String path) {
        SVNReference reference = this.getReference(repository, path);
        SVNHistory history = new SVNHistory();
        if (this.isTrunkOrBranch(repository, reference.getPath())) {
            history = history.add(reference);
        }
        int depth = 6;
        while (reference != null && depth > 0) {
            --depth;
            SVNReference origin = this.getOrigin(repository, reference);
            if (origin != null) {
                if (this.isTrunkOrBranch(repository, origin.getPath())) {
                    history = history.add(origin);
                }
                reference = origin;
                continue;
            }
            reference = null;
        }
        return history;
    }

    @Override
    public List<SVNRevisionPath> getRevisionPaths(SVNRepository repository, long revision) {
        ArrayList<SVNRevisionPath> paths = new ArrayList<SVNRevisionPath>();
        SVNURL rootUrl = repository.getRootUrl();
        try {
            this.getDiffClient(repository).doDiffStatus(rootUrl, SVNRevision.create((long)(revision - 1L)), rootUrl, SVNRevision.create((long)revision), SVNDepth.INFINITY, false, diffStatus -> {
                if (diffStatus.getKind() == SVNNodeKind.FILE) {
                    paths.add(new SVNRevisionPath("/" + diffStatus.getPath(), this.toFileChangeType(diffStatus.getModificationType())));
                }
            });
        }
        catch (SVNException ex) {
            throw this.translateSVNException(ex);
        }
        return paths;
    }

    @Override
    public List<String> getBranches(SVNRepository repository, SVNURL url) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.getLogClient(repository).doList(url, SVNRevision.HEAD, SVNRevision.HEAD, false, false, dirEntry -> {
                if (dirEntry.getKind() == SVNNodeKind.DIR) {
                    results.add(dirEntry.getName());
                }
            });
        }
        catch (SVNException ex) {
            throw this.translateSVNException(ex);
        }
        return results;
    }

    @Override
    public String getDiff(SVNRepository repository, String path, List<Long> revisions) {
        SVNRevision min = SVNRevision.create((long)((Long)revisions.stream().min(Long::compare).get() - 1L));
        SVNRevision max = SVNRevision.create((long)((Long)revisions.stream().max(Long::compare).get()));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.getDiffClient(repository).doDiff(SVNUtils.toURL(repository.getUrl(path)), max, min, max, SVNDepth.EMPTY, false, (OutputStream)output);
        }
        catch (SVNException ex) {
            throw this.translateSVNException(ex);
        }
        return Utils.toString((byte[])output.toByteArray());
    }

    @Override
    public Optional<String> download(SVNRepository repository, String path) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getWCClient(repository).doGetFileContents(SVNUtils.toURL(repository.getUrl(path)), SVNRevision.HEAD, SVNRevision.HEAD, false, (OutputStream)out);
            return Optional.of(IOUtils.toString((byte[])out.toByteArray(), (String)"UTF-8"));
        }
        catch (IOException | SVNException ex) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getBasePath(SVNRepository svnRepository, String branchPath) {
        if (this.isTrunk(branchPath)) {
            return Optional.of(StringUtils.stripEnd((String)StringUtils.substringBefore((String)branchPath, (String)"trunk"), (String)"/"));
        }
        if (this.isBranch(svnRepository, branchPath)) {
            return Optional.of(StringUtils.stripEnd((String)StringUtils.substringBefore((String)branchPath, (String)"branches"), (String)"/"));
        }
        return Optional.empty();
    }

    private SCMChangeLogFileChangeType toFileChangeType(SVNStatusType modificationType) {
        if (modificationType.equals(SVNStatusType.STATUS_MODIFIED)) {
            return SCMChangeLogFileChangeType.MODIFIED;
        }
        if (modificationType.equals(SVNStatusType.STATUS_ADDED)) {
            return SCMChangeLogFileChangeType.ADDED;
        }
        if (modificationType.equals(SVNStatusType.STATUS_DELETED)) {
            return SCMChangeLogFileChangeType.DELETED;
        }
        return SCMChangeLogFileChangeType.UNDEFINED;
    }

    @Override
    public SVNReference getReference(SVNRepository repository, String path) {
        Matcher matcher = this.pathWithRevision.matcher(path);
        if (matcher.matches()) {
            String pathOnly = matcher.group(1);
            long revision = Long.parseLong(matcher.group(2), 10);
            return this.getReference(repository, pathOnly, SVNRevision.create((long)revision));
        }
        return this.getReference(repository, path, SVNRevision.HEAD);
    }

    private SVNReference getReference(SVNRepository repository, String path, SVNRevision revision) {
        String url = repository.getUrl(path);
        SVNURL svnurl = SVNUtils.toURL(url);
        SVNInfo info = this.getInfo(repository, svnurl, revision);
        return new SVNReference(path, url, info.getRevision().getNumber(), Time.from((Date)info.getCommittedDate(), null));
    }

    @Override
    public SVNInfo getInfo(SVNRepository repository, SVNURL url, SVNRevision revision) {
        try {
            return this.getWCClient(repository).doInfo(url, revision, revision);
        }
        catch (SVNException e) {
            throw this.translateSVNException(e);
        }
    }

    private SVNReference getOrigin(SVNRepository repository, SVNReference destination) {
        TCopyEvent copyEvent = this.svnEventDao.getLastCopyEvent(repository.getId(), destination.getPath(), destination.getRevision());
        if (copyEvent != null) {
            return this.getReference(repository, copyEvent.getCopyFromPath(), SVNRevision.create((long)copyEvent.getCopyFromRevision()));
        }
        return null;
    }

    @Override
    public boolean isTrunkOrBranch(SVNRepository repository, String path) {
        return this.isTrunk(path) || this.isBranch(repository, path);
    }

    @Override
    public boolean isTagOrBranch(SVNRepository repository, String path) {
        return this.isTag(repository, path) || this.isBranch(repository, path);
    }

    @Override
    public boolean isTag(SVNRepository repository, String path) {
        return this.isPathOK(repository.getTagPattern(), path);
    }

    @Override
    public boolean isBranch(SVNRepository repository, String path) {
        return this.isPathOK(repository.getBranchPattern(), path);
    }

    private boolean isPathOK(String pattern, String path) {
        return StringUtils.isNotBlank((CharSequence)pattern) && Pattern.matches(pattern, path);
    }

    @Override
    public boolean isTrunk(String path) {
        return this.isPathOK(".*/trunk", path);
    }

    private SVNClientException translateSVNException(SVNException e) {
        return new SVNClientException(e);
    }

    protected SVNWCClient getWCClient(SVNRepository repository) {
        return this.getClientManager(repository).getWCClient();
    }

    protected SVNLogClient getLogClient(SVNRepository repository) {
        return this.getClientManager(repository).getLogClient();
    }

    protected SVNDiffClient getDiffClient(SVNRepository repository) {
        return this.getClientManager(repository).getDiffClient();
    }

    protected SVNClientManager getClientManager(SVNRepository repository) {
        Transaction transaction = this.transactionService.get();
        if (transaction == null) {
            throw new IllegalStateException("All SVN calls must be part of a SVN transaction");
        }
        return ((SVNSession)transaction.getResource(SVNSession.class, (Object)repository.getId(), () -> {
            SVNClientManager clientManager = SVNClientManager.newInstance();
            String svnUser = repository.getConfiguration().getUser();
            String svnPassword = repository.getConfiguration().getPassword();
            if (StringUtils.isNotBlank((CharSequence)svnUser) && StringUtils.isNotBlank((CharSequence)svnPassword)) {
                clientManager.setAuthenticationManager((ISVNAuthenticationManager)BasicAuthenticationManager.newInstance((String)svnUser, (char[])svnPassword.toCharArray()));
            }
            return new SVNSessionImpl(clientManager);
        })).getClientManager();
    }
}

