/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalLong;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.service.SVNChangeLogService;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNRevisionDecorationExtension
extends AbstractExtension
implements DecorationExtension<Long> {
    private final SVNChangeLogService svnChangeLogService;

    @Autowired
    public SVNRevisionDecorationExtension(SVNExtensionFeature extensionFeature, SVNChangeLogService svnChangeLogService) {
        super((ExtensionFeature)extensionFeature);
        this.svnChangeLogService = svnChangeLogService;
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.of(ProjectEntityType.BUILD);
    }

    public List<Decoration<Long>> getDecorations(ProjectEntity entity) {
        if (entity instanceof Build) {
            OptionalLong revision = this.svnChangeLogService.getBuildRevision((Build)entity);
            if (revision.isPresent()) {
                if (StringUtils.equals((CharSequence)String.valueOf(revision.getAsLong()), (CharSequence)((Build)entity).getName())) {
                    return Collections.emptyList();
                }
                long lRevision = revision.getAsLong();
                return Collections.singletonList(Decoration.of((Decorator)this, (Object)lRevision));
            }
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("Expecting build");
    }
}

