/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.SearchExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.extension.svn.SVNController;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNRepositoryIssue;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.SearchProvider;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Component
public class SVNIssueSearchExtension
extends AbstractExtension
implements SearchExtension {
    private final URIBuilder uriBuilder;
    private final IssueServiceRegistry issueServiceRegistry;
    private final SVNConfigurationService configurationService;
    private final SVNService svnService;

    @Autowired
    public SVNIssueSearchExtension(SVNExtensionFeature extensionFeature, URIBuilder uriBuilder, IssueServiceRegistry issueServiceRegistry, SVNConfigurationService configurationService, SVNService svnService) {
        super((ExtensionFeature)extensionFeature);
        this.uriBuilder = uriBuilder;
        this.issueServiceRegistry = issueServiceRegistry;
        this.configurationService = configurationService;
        this.svnService = svnService;
    }

    public SearchProvider getSearchProvider() {
        return new AbstractSearchProvider(this.uriBuilder){

            public boolean isTokenSearchable(String token) {
                return SVNIssueSearchExtension.this.issueServiceRegistry.getIssueServices().stream().filter(s -> s.validIssueToken(token)).findAny().isPresent();
            }

            public Collection<SearchResult> search(String token) {
                return SVNIssueSearchExtension.this.configurationService.getConfigurationDescriptors().stream().map(descriptor -> SVNIssueSearchExtension.this.svnService.getRepository(descriptor.getId())).map(repository -> SVNIssueSearchExtension.this.svnService.searchIssues((SVNRepository)repository, token)).filter(Optional::isPresent).map(Optional::get).map(repositoryIssue -> new SearchResult(repositoryIssue.getIssue().getKey(), SVNIssueSearchExtension.this.getSearchIssueDescription(repositoryIssue), this.uri(((SVNController)((Object)((Object)MvcUriComponentsBuilder.on(SVNController.class)))).issueInfo(repositoryIssue.getRepository().getConfiguration().getName(), repositoryIssue.getIssue().getKey())), this.uriBuilder.page("extension/svn/issue/%s/%s", new Object[]{repositoryIssue.getRepository().getConfiguration().getName(), repositoryIssue.getIssue().getKey()}), 100)).collect(Collectors.toList());
            }
        };
    }

    private String getSearchIssueDescription(SVNRepositoryIssue repositoryIssue) {
        return String.format("Issue %s in %s repository: %s", repositoryIssue.getIssue().getKey(), repositoryIssue.getRepository().getConfiguration().getName(), repositoryIssue.getIssue().getSummary());
    }
}

