/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import net.nemerosa.ontrack.extension.api.BuildValidationExtension;
import net.nemerosa.ontrack.extension.api.model.BuildValidationException;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.model.BuildSvnRevisionLinkService;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.support.ConfiguredBuildSvnRevisionLink;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNBuildValidationExtension
extends AbstractExtension
implements BuildValidationExtension {
    private final PropertyService propertyService;
    private final BuildSvnRevisionLinkService buildSvnRevisionLinkService;

    @Autowired
    public SVNBuildValidationExtension(SVNExtensionFeature feature, PropertyService propertyService, BuildSvnRevisionLinkService buildSvnRevisionLinkService) {
        super((ExtensionFeature)feature);
        this.propertyService = propertyService;
        this.buildSvnRevisionLinkService = buildSvnRevisionLinkService;
    }

    public void validateBuild(Build build) throws BuildValidationException {
        this.propertyService.getProperty((ProjectEntity)build.getBranch(), SVNBranchConfigurationPropertyType.class).option().ifPresent(property -> {
            ConfiguredBuildSvnRevisionLink revisionLink = this.buildSvnRevisionLinkService.getConfiguredBuildSvnRevisionLink(property.getBuildRevisionLink());
            if (!revisionLink.isValidBuildName(build.getName())) {
                throw new BuildValidationException(String.format("Build %s does not comply with the SVN configuration", build.getName()));
            }
        });
    }
}

