"use strict";angular.module("ontrack.extension.svn",["ui.router","ontrack.extension.scm","ot.service.core","ot.service.structure","ot.service.configuration","ot.service.form"]).config(["$stateProvider",function(n){n.state("svn-configurations",{url:"/extension/svn/configurations",templateUrl:"extension/svn/svn.configurations.tpl.html",controller:"SVNConfigurationsCtrl"})}]).controller("SVNConfigurationsCtrl",["$scope","$http","$modal","ot","otFormService","otAlertService","otConfigurationService",function(n,e,i,o,t,s,r){function a(){n.loadingConfigurations=!0,o.call(e.get("extension/svn/configurations")).then(function(e){n.configurations=e,c.commands=[{id:"svn-configuration-create",name:"Create a configuration",cls:"ot-command-new",action:n.createConfiguration},o.viewApiCommand(e._self),o.viewCloseCommand("/home")]})["finally"](function(){n.loadingConfigurations=!1})}var c=o.view();c.title="SVN configurations",c.description="Management of the SVN configurations.",n.configurationFilter="",n.loadingConfigurations=!0,a(),n.createConfiguration=function(){t.display({uri:n.configurations._create,title:"SVN configuration",buttons:[r.testButton(n.configurations._test)],submit:function(i){return o.call(e.post(n.configurations._create,i))}}).then(a)},n.deleteConfiguration=function(i){s.confirm({title:"Deleting configuration",message:"Do you really want to delete this SVN configuration? Some projects may still refer to it."}).then(function(){n.loadingConfigurations=!0,o.call(e["delete"](i._delete)).then(a)})},n.updateConfiguration=function(i){t.display({uri:i._update,title:"SVN configuration",buttons:[r.testButton(n.configurations._test)],submit:function(n){return o.call(e.put(i._update,n))}}).then(a)},n.indexation=function(n){i.open({templateUrl:"extension/svn/svn.dialog.indexation.tpl.html",controller:"svnDialogIndexation",resolve:{config:function(){return{configuration:n}}}})}}]).directive("otExtensionSvnRevisionSummary",function(){return{restrict:"E",templateUrl:"extension/svn/directive.revision.summary.tpl.html",transclude:!0,scope:{revisionInfo:"=",title:"@"}}}).directive("otExtensionSvnRevisionBuilds",function(){return{restrict:"E",templateUrl:"extension/svn/directive.revision.builds.tpl.html",scope:{ontrackSvnRevisionInfo:"=",mergedRevisionInfos:"="}}}).directive("otExtensionSvnRevisionPromotions",function(){return{restrict:"E",templateUrl:"extension/svn/directive.revision.promotions.tpl.html",scope:{ontrackSvnRevisionInfo:"=",mergedRevisionInfos:"="}}}).config(["$stateProvider",function(n){n.state("svn-changelog",{url:"/extension/svn/changelog?from&to",templateUrl:"extension/svn/svn.changelog.tpl.html",controller:"SVNChangeLogCtrl"})}]).controller("SVNChangeLogCtrl",["$q","$log","$interpolate","$anchorScroll","$location","$stateParams","$scope","$http","ot","otStructureService","otScmChangeLogService","otScmChangelogFilechangefilterService",function(n,e,i,o,t,s,r,a,c,l,u,f){r.buildDiffRequest={from:s.from,to:s.to};var g=c.view();g.title="Subversion change log";var v=t.path().substring(1);c.pageCall(a.get(v,{params:r.buildDiffRequest})).then(function(n){r.changeLog=n,g.breadcrumbs=c.projectBreadcrumbs(n.project),r.revisionsCommand="Revisions",r.issuesCommand="Issues",r.filesCommand="File changes",r.changeLogRevisions=function(){r.revisions?(t.hash("revisions"),o()):(r.revisionsLoading=!0,r.revisionsCommand="Loading the revisions...",c.pageCall(a.get(r.changeLog._revisions)).then(function(n){r.revisions=n,r.revisionsLoading=!1,r.revisionsCommand="Revisions",t.hash("revisions"),o()}))},r.changeLogIssues=function(){r.issues?(t.hash("issues"),o()):(r.issuesLoading=!0,r.issuesCommand="Loading the issues...",c.pageCall(a.get(r.changeLog._issues)).then(function(n){r.issues=n,r.issuesLoading=!1,r.issuesCommand="Issues",t.hash("issues"),o()}))},r.changeLogFiles=function(){r.files?(t.hash("files"),o()):(r.filesLoading=!0,r.filesCommand="Loading the file changes...",c.pageCall(a.get(r.changeLog._files)).then(function(n){r.files=n,r.filesLoading=!1,r.filesCommand="File changes",t.hash("files"),o()}))},r.changeLogFileFilterConfig=f.initFilterConfig(),r.changeLogExport=function(){u.displayChangeLogExport({changeLog:r.changeLog,exportFormatsLink:n._exportFormats,exportIssuesLink:n._exportIssues})},r.showFileDiff=function(n,e){r.diffLoading||(r.diffLoading=!0,e.diffLoading=!0,f.diffFileFilter(n,e.path)["finally"](function(){e.diffLoading=!1,r.diffLoading=!1}))}})}]).controller("svnDialogIndexation",["$scope","$modalInstance","$http","config","ot","otAlertService","otFormService",function(n,e,i,o,t,s,r){function a(e){e.success?n.cancel():n.message={type:"warning",content:"Indexation is already running on this repository."}}n.config=o,t.call(i.get(o.configuration._indexation)).then(function(e){n.lastRevisionInfo=e}),n.cancel=function(){e.dismiss("cancel")},n.indexFromLatest=function(){t.call(i.post(n.config.configuration._indexationFromLatest)).then(a,function(e){n.message=e})},n.fullReindexation=function(){s.confirm({title:"Full re-indexation",message:"Are you sure to fully re-index the repository? All associated cached data (revisions, issues...) will be lost."}).then(function(){t.call(i.post(n.config.configuration._indexationFull)).then(a,function(e){n.message=e})})}}]).config(["$stateProvider",function(n){n.state("svn-issue",{url:"/extension/svn/issue/{configuration}/{issue}",templateUrl:"extension/svn/svn.issue.tpl.html",controller:"SVNIssueCtrl"})}]).controller("SVNIssueCtrl",["$stateParams","$scope","$http","$interpolate","ot",function(n,e,i,o,t){var s=(n.configuration,n.issue,t.view());s.title=o("Issue {{issue}} in {{configuration}} repository")(n),t.call(i.get(o("extension/svn/configuration/{{configuration}}/issue/{{issue}}")(n))).then(function(n){e.ontrackSVNIssueInfo=n})}]).config(["$stateProvider",function(n){n.state("svn-revision",{url:"/extension/svn/revision/{configuration}/{revision}",templateUrl:"extension/svn/svn.revision.tpl.html",controller:"SVNRevisionCtrl"})}]).controller("SVNRevisionCtrl",["$stateParams","$scope","$http","$interpolate","ot",function(n,e,i,o,t){var s=(n.configuration,n.revision,t.view());s.title=o("Revision {{revision}} in {{configuration}} repository")(n),t.call(i.get(o("extension/svn/configuration/{{configuration}}/revision/{{revision}}")(n))).then(function(n){e.ontrackSVNRevisionInfo=n})}]).config(["$stateProvider",function(n){n.state("svn-sync",{url:"/extension/svn/sync/{branch}",templateUrl:"extension/svn/svn.sync.tpl.html",controller:"SVNSyncCtrl"})}]).controller("SVNSyncCtrl",["$stateParams","$state","$scope","$http","$interpolate","ot","otStructureService","otNotificationService",function(n,e,i,o,t,s,r,a){function c(){r.getBranch(l).then(function(n){i.branch=n,u.title=t("Build synchronisation for branch {{project.name}}/{{name}}")(n),u.breadcrumbs=s.branchBreadcrumbs(n)})}var l=n.branch,u=s.view();u.commands=[s.viewCloseCommand("/branch/"+l)],c(),i.launchSync=function(){s.pageCall(o.post("extension/svn/sync/"+l,{})).then(function(){a.info("The build synchronisation has been launched in the background."),e.go("branch",{branchId:l})})}}]);
angular.module("ontrack-extension-svn-templates",[]).run(["$log","$templateCache",function(n,i){n.info("Loading templates for svn @ 3.43.21"),i.put("extension/svn/directive.revision.builds.tpl.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        Associated builds\n    </div>\n    <table class="table">\n        <thead>\n        <tr>\n            <th>&nbsp;</th>\n            <th>Project</th>\n            <th>Branch</th>\n            <th>Build</th>\n            <th>Validation stamps</th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat="buildView in ontrackSvnRevisionInfo.buildViews">\n            <td>\n                &nbsp;\n            </td>\n            <td>\n                <a href="#/project/{{buildView.build.branch.project.id}}">{{buildView.build.branch.project.name}}</a>\n            </td>\n            <td>\n                <a href="#/branch/{{buildView.build.branch.id}}">{{buildView.build.branch.name}}</a>\n            </td>\n            <td>\n                <a href="#/build/{{buildView.build.id}}">{{buildView.build.name}}</a>\n            </td>\n            <td>\n                <span ng-repeat="validationStampRunView in buildView.validationStampRunViews" class="ot-extension-scm-validationStampRunView">\n                    <ot-validation-stamp-run-view validation-stamp-run-view="validationStampRunView"></ot-validation-stamp-run-view>\n                </span>\n            </td>\n        </tr>\n        </tbody>\n        <!-- Merged revision info -->\n        <tbody ng-repeat="mergedRevisionInfo in mergedRevisionInfos">\n            <tr ng-repeat="buildView in mergedRevisionInfo.buildViews">\n                <td>\n                    <a href="#/extension/svn/configuration/{{ontrackSvnRevisionInfo.configuration.name}}/revision/{{mergedRevisionInfo.revisionInfo.revision}}">\n                        {{mergedRevisionInfo.revisionInfo.revision}}\n                    </a>\n                </td>\n                <td>\n                    <a href="#/project/{{buildView.build.branch.project.id}}">{{buildView.build.branch.project.name}}</a>\n                </td>\n                <td>\n                    <a href="#/branch/{{buildView.build.branch.id}}">{{buildView.build.branch.name}}</a>\n                </td>\n                <td>\n                    <a href="#/build/{{buildView.build.id}}">{{buildView.build.name}}</a>\n                </td>\n                <td>\n                <span ng-repeat="validationStampRunView in buildView.validationStampRunViews" class="ot-extension-scm-validationStampRunView">\n                    <ot-validation-stamp-run-view validation-stamp-run-view="validationStampRunView"></ot-validation-stamp-run-view>\n                </span>\n                </td>\n            </tr>\n        </tbody>\n    </table>\n</div>'),i.put("extension/svn/directive.revision.promotions.tpl.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        Associated promotions\n    </div>\n    <div class="panel-body">\n        <div class="panel panel-info" ng-repeat="branchStatusView in ontrackSvnRevisionInfo.branchStatusViews">\n            <div class="panel-heading">\n                Project\n                <a href="#/project/{{branchStatusView.branch.project.id}}">{{branchStatusView.branch.project.name}}</a>\n                Branch\n                <a href="#/branch/{{branchStatusView.branch.id}}">{{branchStatusView.branch.name}}</a>\n            </div>\n            <table class="table">\n                <thead>\n                <tr>\n                    <th>Promotion level</th>\n                    <th>Build</th>\n                </tr>\n                </thead>\n                <tbody>\n                <tr ng-repeat="promotionView in branchStatusView.promotions">\n                    <td>\n                        <a href="#/promotionLevel/{{promotionView.promotionLevel.id}}">\n                            <ot-entity-image entity="promotionView.promotionLevel"></ot-entity-image>\n                            {{promotionView.promotionLevel.name}}\n                        </a>\n                    </td>\n                    <td>\n                        <span class="ot-description" ng-if="!promotionView.promotionRun">\n                            The revision was never promoted to this promotion level.\n                        </span>\n                        <span ng-if="promotionView.promotionRun">\n                            <span class="fa fa-arrow-right"></span>\n                            <a href="#/build/{{promotionView.promotionRun.build.id}}">\n                                {{promotionView.promotionRun.build.name}}\n                            </a>\n                            <ot-signature value="promotionView.promotionRun.signature"></ot-signature>\n                        </span>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</div>'),i.put("extension/svn/directive.revision.summary.tpl.html",'<div class="panel panel-default">\n    <div class="panel-heading" ng-if="title">\n        Revision\n        <a href="{{revisionInfo.revisionUrl}}" target="_blank">\n            {{revisionInfo.revision}}\n        </a>\n    </div>\n    <div class="panel-body">\n        <p ng-bind-html="revisionInfo.formattedMessage"></p>\n        <p class="ot-description">\n            --\n            {{revisionInfo.author}},\n            {{revisionInfo.revisionDate | date:\'mediumDate\'}}\n            {{revisionInfo.revisionDate | date:\'shortTime\'}}\n        </p>\n    </div>\n    <div ng-transclude>\n    </div>\n</div>'),i.put("extension/svn/help.net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType.buildPath.tpl.html","<p>Path of a tag in the Subversion repository using a build name.\nThe path is computed relatively to the root of the repository.</p>\n<p>The <code>{build}</code> placeholder is used  to define the location where\nto replace the path fragment by the build name. An optional expression can follow\nthe build keyword: <code>{build:expression}</code>. In this case  the build name\nmust match the expression, where <code>*</code> stands for any suite of characters.\nFor example: <code>{build:2.7.*}</code> will match <code>build 2.7.0-15</code>,\nbut not <code>2.8.0</code>.</p>"),i.put("extension/svn/svn.changelog.tpl.html",'<ot-view>\n\n    <div class="row" ng-hide="changeLog">\n        <div class="col-md-12 alert alert-warning">\n            <ot-loading>\n                The change log is loading. This may take some time...\n            </ot-loading>\n        </div>\n    </div>\n\n    <div class="row" ng-show="changeLog">\n        <div class="col-md-12">\n\n            <!-- Main content -->\n            <div class="row">\n                <div class="col-md-12 ot-header-commands">\n                    <button class="btn btn-default" ng-click="changeLogRevisions()" ng-disabled="revisionsLoading">\n                        <ot-loading ng-if="revisionsLoading"></ot-loading>\n                        <span class="ot-header-command-unloaded" ng-hide="revisions || revisionsLoading"></span>\n                        {{revisionsCommand}}\n                    </button>\n                    <button ng-if="changeLog._issues" class="btn btn-default" ng-click="changeLogIssues()" ng-disabled="issuesLoading">\n                        <ot-loading ng-if="issuesLoading"></ot-loading>\n                        <span class="ot-header-command-unloaded" ng-hide="issues || issuesLoading"></span>\n                        {{issuesCommand}}\n                    </button>\n                    <button class="btn btn-default" ng-click="changeLogFiles()" ng-disabled="filesLoading">\n                        <ot-loading ng-if="filesLoading"></ot-loading>\n                        <span class="ot-header-command-unloaded" ng-hide="files || filesLoading"></span>\n                        {{filesCommand}}\n                    </button>\n                </div>\n            </div>\n\n            <!-- Build info -->\n            <div class="row">\n                <div class="col-md-6">\n                    <a name="buildFrom"></a>\n                    <ot-scm-changelog-build scm-build-view="changeLog.scmBuildFrom">\n                        <div class="row">\n                            <div class="col-md-12">\n                                <h3>\n                                    <small>History</small>\n                                </h3>\n                                <ul>\n                                    <li ng-repeat="reference in changeLog.scmBuildFrom.scm.references">\n                                        <a href="{{reference.url}}">\n                                            {{reference.path}}\n                                            @\n                                            {{reference.revision}}\n                                        </a>\n                                    </li>\n                                </ul>\n                            </div>\n                        </div>\n                    </ot-scm-changelog-build>\n                </div>\n                <div class="col-md-6">\n                    <a id="buildTo"></a>\n                    <ot-scm-changelog-build scm-build-view="changeLog.scmBuildTo">\n                        <div class="row">\n                            <div class="col-md-12">\n                                <h3>\n                                    <small>History</small>\n                                </h3>\n                                <ul>\n                                    <li ng-repeat="reference in changeLog.scmBuildTo.scm.references">\n                                        <a href="{{reference.url}}">\n                                            {{reference.path}}\n                                            @\n                                            {{reference.revision}}\n                                        </a>\n                                    </li>\n                                </ul>\n                            </div>\n                        </div>\n                    </ot-scm-changelog-build>\n                </div>\n            </div>\n\n            <!-- Revision sections -->\n            <div class="row">\n                <div class="col-md-12">\n                    <a name="revisions"></a>\n\n                    <div class="panel panel-default">\n                        <div class="panel-heading clearfix">\n                            Revisions\n                            <div class="pull-right">\n                                <a class="btn btn-default btn-xs" ng-if="changeLog._issues" ng-click="changeLogIssues()" ng-disabled="issuesLoading">\n                                    <ot-loading ng-if="issuesLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="issues || issuesLoading"></span>\n                                    {{issuesCommand}}\n                                </a>\n                                <a class="btn btn-default btn-xs" ng-click="changeLogFiles()" ng-disabled="filesLoading">\n                                    <ot-loading ng-if="filesLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="files || filesLoading"></span>\n                                    {{filesCommand}}\n                                </a>\n                            </div>\n                        </div>\n                        <div class="panel-body">\n                            <div class="alert alert-warning" ng-hide="revisions || revisionsLoading">\n                                No revision has been loaded yet. Click\n                                <a ng-click="changeLogRevisions()" class="ot-action">here</a>\n                                to load them.\n                            </div>\n                            <div class="ot-description" ng-show="revisionsLoading">\n                                <ot-loading>Revisions are loading...</ot-loading>\n                            </div>\n                            <!-- Merge -->\n                            <table class="table table-condensed table-hover" ng-show="revisions">\n                                <thead>\n                                <tr>\n                                    <th>Revision</th>\n                                    <th>Author</th>\n                                    <th>Date</th>\n                                    <th>Message</th>\n                                </tr>\n                                </thead>\n                                <tbody>\n                                <tr ng-repeat="svnChangeLogRevision in revisions.list">\n                                    <td>\n                                        <a href="{{svnChangeLogRevision.revisionUrl}}" target="_blank">\n                                            {{svnChangeLogRevision.revision}}\n                                        </a>\n                                    </td>\n                                    <td>\n                                        {{svnChangeLogRevision.author}}\n                                    </td>\n                                    <td class="ot-line-no-overflow">\n                                        {{svnChangeLogRevision.revisionDate | date:\'mediumDate\'}}\n                                        {{svnChangeLogRevision.revisionDate | date:\'shortTime\'}}\n                                    </td>\n                                    <td ng-bind-html="svnChangeLogRevision.formattedMessage">\n                                    </td>\n                                </tr>\n                                </tbody>\n                            </table>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- Issue sections -->\n            <div class="row" ng-if="changeLog._issues">\n                <div class="col-md-12">\n                    <a name="issues"></a>\n\n                    <div class="panel panel-default">\n                        <div class="panel-heading clearfix">\n                            Issues\n                            <div class="pull-right">\n                                <a class="btn btn-default btn-xs" ng-click="changeLogRevisions()" ng-disabled="revisionsLoading">\n                                    <ot-loading ng-if="revisionsLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="revisions || revisionsLoading"></span>\n                                    {{revisionsCommand}}\n                                </a>\n                                <a class="btn btn-default btn-xs" ng-click="changeLogFiles()" ng-disabled="filesLoading">\n                                    <ot-loading ng-if="filesLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="files || filesLoading"></span>\n                                    {{filesCommand}}\n                                </a>\n                                <a class="btn btn-default btn-xs" ng-click="changeLogExport()">\n                                    <span class="fa fa-file-text-o"></span>\n                                    Export\n                                </a>\n                            </div>\n                        </div>\n                        <div class="panel-body">\n                            <div class="alert alert-warning" ng-hide="issues || issuesLoading">\n                                No issue has been loaded yet. Click\n                                <a ng-click="changeLogIssues()" class="ot-action">here</a>\n                                to load them.\n                            </div>\n                            <div class="ot-description" ng-show="issuesLoading">\n                                <ot-loading>Issues are loading...</ot-loading>\n                            </div>\n                            <div ng-show="issues">\n                                <ot-include value="issues" template="extension/{{issues.issueServiceConfiguration.serviceId}}/changelog.issues.tpl.html">\n                                </ot-include>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- Files sections -->\n            <div class="row">\n                <div class="col-md-12">\n                    <a name="files"></a>\n\n                    <div class="panel panel-default">\n                        <div class="panel-heading clearfix">\n                            File changes\n                            <div class="pull-right">\n                                <a class="btn btn-default btn-xs" ng-click="changeLogRevisions()" ng-disabled="revisionsLoading">\n                                    <ot-loading ng-if="revisionsLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="revisions || revisionsLoading"></span>\n                                    {{revisionsCommand}}\n                                </a>\n                                <a class="btn btn-default btn-xs" ng-if="changeLog._issues" ng-click="changeLogIssues()" ng-disabled="issuesLoading">\n                                    <ot-loading ng-if="issuesLoading"></ot-loading>\n                                    <span class="ot-header-command-unloaded" ng-hide="issues || issuesLoading"></span>\n                                    {{issuesCommand}}\n                                </a>\n                            </div>\n                        </div>\n                        <div class="panel-body" ng-hide="files || filesLoading">\n                            <div class="alert alert-warning">\n                                No file change has been loaded yet. Click\n                                <a ng-click="changeLogFiles()" class="ot-action">here</a>\n                                to load them.\n                            </div>\n                        </div>\n                        <div class="panel-body ot-description" ng-show="filesLoading">\n                            <ot-loading>File changes are loading...</ot-loading>\n                        </div>\n                        <div class="panel-body ot-panel-padded" ng-show="files">\n                            <ot-extension-scm-changelog-filechangefilter change-log="changeLog" filter-callback="changeLogFileFilterConfig.callback"></ot-extension-scm-changelog-filechangefilter>\n                        </div>\n                        <div class="panel-body ot-panel-padded" ng-show="files">\n                            <div class="ot-line-no-overflow ot-line-hover ot-line-border"\n                                 ng-repeat="svnChangeLogFile in files.list | filter:changeLogFileFilterConfig.filter">\n                                <a href="{{svnChangeLogFile.url}}">\n                                    {{svnChangeLogFile.path}}\n                                </a>\n                                <span ng-repeat="svnChangeLogFileChange in svnChangeLogFile.changes" class="ot-label-change ot-label-change-{{svnChangeLogFileChange.changeType | lowercase}}">\n                                    <span class="ot-label-change-icon"></span>\n                                    <a href="{{svnChangeLogFileChange.url}}"\n                                       title="{{svnChangeLogFileChange.revisionInfo.message}} ({{svnChangeLogFileChange.revisionInfo.dateTime | date:\'mediumDate\'}})">\n                                        {{svnChangeLogFileChange.revisionInfo.revision}}\n                                    </a>\n                                </span>\n                                <span ng-hide="svnChangeLogFile.diffLoading || diffLoading" class="fa fa-download ot-command" title="Shows diff" ng-click="showFileDiff(changeLog, svnChangeLogFile)"></span>\n                                <span ng-show="svnChangeLogFile.diffLoading" class="fa fa-spin fa-spinner ot-command" title="Diff is loading..."></span>\n                            </div>\n                        </div>\n                    </div>\n                </div>\n            </div>\n\n            <!-- End of sections -->\n\n        </div>\n    </div>\n\n</ot-view>'),i.put("extension/svn/svn.configurations.tpl.html",'<ot-view>\n    <div class="row" ng-show="loadingConfigurations">\n        <div class="col-md-12">\n            <div class="alert alert-info">\n                <span class="ot-loading-indicator"></span>\n                Loading the configurations...\n            </div>\n        </div>\n    </div>\n    <div class="row" ng-hide="loadingConfigurations">\n        <div class="col-md-12">\n            <ot-section-title>List of configurations</ot-section-title>\n            <div class="row" ng-show="configurations.resources.length > 5">\n                <div class="col-md-12">\n                    <input id="configuration-filter" ng-model="configurationFilter"\n                           class="form-control col-md-2"\n                           placeholder="Filter on configurations"\n                           />\n                </div>\n            </div>\n            <ot-noentry list="configurations.resources">\n                No Jenkins configuration has been created yet.\n            </ot-noentry>\n            <table class="table table-hover">\n                <tr ng-repeat="configuration in configurations.resources | filter:configurationFilter">\n                    <td>\n                        <code>{{configuration.name}}</code>\n                    </td>\n                    <td>\n                        <span ng-if="configuration.user">\n                            {{configuration.user}} @\n                        </span>\n                        <a href="{{configuration.url}}" target="_blank">{{configuration.url}}</a>\n                    </td>\n                    <td>\n                        <span class="ot-command" ng-click="updateConfiguration(configuration)">\n                            <span class="ot-command-update"></span>\n                            Update\n                        </span>\n                        <span class="ot-command" ng-click="deleteConfiguration(configuration)">\n                            <span class="ot-command-delete"></span>\n                            Delete\n                        </span>\n                        <span class="ot-command" ng-click="indexation(configuration)">\n                            <span class="fa fa-bolt"></span>\n                            Indexation\n                        </span>\n                    </td>\n                </tr>\n            </table>\n        </div>\n    </div>\n</ot-view>'),i.put("extension/svn/svn.dialog.indexation.tpl.html",'<div class="modal-header">\n    <h3>Indexation</h3>\n</div>\n<div class="modal-body">\n\n    <section>\n        <h1><small>Last scanned revision</small></h1>\n        <ul ng-if="!lastRevisionInfo.none">\n            <li>Last revision: {{lastRevisionInfo.revision}}</li>\n            <li>Last message: {{lastRevisionInfo.message}}</li>\n            <li>Last revision in repository: {{lastRevisionInfo.repositoryRevision}}</li>\n        </ul>\n        <div class="alert alert-warning" ng-if="lastRevisionInfo.none">\n            None\n        </div>\n    </section>\n\n    <section>\n        <h1><small>Index</small></h1>\n        <p>Click on the following button to launch an indexation from the latest indexed revision.</p>\n        <button type="button" class="btn btn-primary" ng-click="indexFromLatest()">Index</button>\n    </section>\n\n    <section>\n        <h1><small>Full re-indexation</small></h1>\n        <p>Click on the following button to launch a full re-indexation of the repository.</p>\n        <p class="alert alert-danger">Warning: you will lose all previously indexed data!</p>\n        <button type="button" class="btn btn-danger" ng-click="fullReindexation()">Full re-indexation</button>\n    </section>\n\n</div>\n<div class="modal-footer">\n\n    <div class="ot-alert-{{message.type}} alert-dismissable" ng-show="message">\n        <span>{{message.content}}</span>\n    </div>\n\n    <button class="btn btn-link" type="button" ng-click="cancel()">Close</button>\n</div>'),i.put("extension/svn/svn.issue.tpl.html",'<ot-view>\n\n    <div class="row" ng-hide="ontrackSVNIssueInfo">\n        <div class="col-md-12 alert alert-warning">\n            The revision information is loading. This may take some time...\n        </div>\n    </div>\n\n    <div class="row" ng-show="ontrackSVNIssueInfo">\n        <div class="col-md-12">\n\n            <div class="panel panel-info">\n                <div class="panel-heading">\n                    <a href="{{ontrackSVNIssueInfo.issue.url}}">\n                        {{ontrackSVNIssueInfo.issue.key}}\n                    </a>\n                </div>\n                <div class="panel-body">\n                    <ot-include value="ontrackSVNIssueInfo.issue"\n                                template="extension/{{ontrackSVNIssueInfo.issueServiceConfigurationRepresentation.serviceId}}/issue.tpl.html">\n                    </ot-include>\n                </div>\n            </div>\n\n            <!-- For each revision info -->\n            <div class="row" ng-repeat="ontrackSVNIssueRevisionInfo in ontrackSVNIssueInfo.revisionInfos">\n                <div class="col-md-12">\n\n                    <!-- Summary for the revision -->\n                    <ot-extension-svn-revision-summary\n                            revision-info="ontrackSVNIssueRevisionInfo.revisionInfo"\n                            title="true"\n                            >\n                        <ot-extension-scm-issue-commit-branch-infos\n                                infos="ontrackSVNIssueRevisionInfo.branchInfos"></ot-extension-scm-issue-commit-branch-infos>\n                    </ot-extension-svn-revision-summary>\n\n                </div>\n            </div>\n\n            <!-- All other revisions -->\n            <div class="panel panel-default">\n                <div class="panel-heading">\n                    All revisions\n                </div>\n                <table class="table">\n                    <thead>\n                    <tr>\n                        <th>Revision</th>\n                        <th>Author</th>\n                        <th>Date</th>\n                        <th>Message</th>\n                    </tr>\n                    </thead>\n                    <tbody>\n                    <tr ng-repeat="revisionInfo in ontrackSVNIssueInfo.revisions" ng-class="{\'success\': $first}">\n                        <td>\n                            <a href="{{revisionInfo.revisionUrl}}">{{revisionInfo.revision}}</a>\n                            <a href="#/extension/svn/revision/{{ontrackSVNIssueInfo.configuration.name}}/{{revisionInfo.revision}}"\n                               title="Displays release information about this revision">\n                                <span class="fa fa-search"></span>\n                            </a>\n                        </td>\n                        <td>\n                            {{revisionInfo.author}}\n                        </td>\n                        <td>\n                            {{revisionInfo.revisionDate | date:\'mediumDate\'}}\n                        </td>\n                        <td ng-bind-html="revisionInfo.formattedMessage"></td>\n                    </tr>\n                    </tbody>\n                </table>\n            </div>\n\n        </div>\n    </div>\n\n</ot-view>'),i.put("extension/svn/svn.revision.tpl.html",'<ot-view>\n\n    <div class="row" ng-hide="ontrackSVNRevisionInfo">\n        <div class="col-md-12 alert alert-warning">\n            The revision information is loading. This may take some time...\n        </div>\n    </div>\n\n    <div class="row" ng-show="ontrackSVNRevisionInfo">\n        <div class="col-md-12">\n\n            <!-- Summary for the revision -->\n            <ot-extension-svn-revision-summary\n                    revision-info="ontrackSVNRevisionInfo.revisionInfo"></ot-extension-svn-revision-summary>\n\n            <!-- Builds for the revision -->\n            <ot-extension-svn-revision-builds\n                    ontrack-svn-revision-info="ontrackSVNRevisionInfo"></ot-extension-svn-revision-builds>\n\n            <!-- Promotions for the revisions -->\n            <ot-extension-svn-revision-promotions\n                    ontrack-svn-revision-info="ontrackSVNRevisionInfo"></ot-extension-svn-revision-promotions>\n\n        </div>\n    </div>\n\n</ot-view>'),i.put("extension/svn/svn.sync.tpl.html",'<ot-view>\n    <p>Click on the button below to create builds from the tags in Subversion:</p>\n    <p>\n        <button class="btn btn-primary" ng-click="launchSync()">\n            <span class="fa fa-tags"></span>\n            Synchronise builds with tags\n        </button>\n    </p>\n    <p class="alert alert-info">\n        The synchronisation will occur in the background and this page will be closed.\n    </p>\n</ot-view>'),i.put("extension/svn/buildRevisionLink/revision.tpl.html",'Build name <span class="fa fa-arrows-h"></span> Revision'),i.put("extension/svn/buildRevisionLink/revisionPattern.help.tpl.html","<p>\n    Pattern which defines a relationship between a build name and a revision.\n</p>\n<p>\n    The pattern is a string which <i>must</i> contain the <code>{revision}</code> token. The rest\n    of the string may contain <code>*</code> tokens, which act as placeholders.\n</p>"),i.put("extension/svn/buildRevisionLink/revisionPattern.tpl.html",'Build name <span class="fa fa-arrows-h"></span> <code>{{property.value.buildRevisionLink.data.pattern}}</code>'),i.put("extension/svn/buildRevisionLink/tag.tpl.html",'Build name <span class="fa fa-arrows-h"></span> Tag'),i.put("extension/svn/buildRevisionLink/tagPattern.help.tpl.html","Pattern of the build name as a tag name. The * is used as a placeholder."),i.put("extension/svn/buildRevisionLink/tagPattern.tpl.html",'Build name <span class="fa fa-arrows-h"></span> Tag <code>{{property.value.buildRevisionLink.data.pattern}}</code>'),i.put("extension/svn/decoration/net.nemerosa.ontrack.extension.svn.SVNProjectDecorator.tpl.html",'<img\n        src="extension/svn/decoration/svn.png"\n        class="ot-icon"\n        title="SVN repository: {{decoration.data}}"\n/>'),i.put("extension/svn/decoration/net.nemerosa.ontrack.extension.svn.SVNRevisionDecorationExtension.tpl.html",'<span class="ot-label-muted">\n    {{decoration.data}}\n</span>'),i.put("extension/svn/information/net.nemerosa.ontrack.extension.svn.BuildSVNInformationExtension.tpl.html",'<div class="panel panel-default">\n    <div class="panel-heading">\n        SVN information\n    </div>\n    <div class="panel-body">\n        <ul class="ot-extension-svn-build-history">\n            <li ng-repeat="reference in value.data.references">\n                <a href="{{reference.url}}">\n                    {{reference.path}}\n                    @\n                    {{reference.revision}}\n                </a>\n            </li>\n        </ul>\n    </div>\n</div>'),i.put("extension/svn/property/net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType.tpl.html",'<ul class="fa-ul">\n    <li>\n        <span class="fa-li fa fa-code-fork"></span>\n        {{property.value.branchPath}}\n    </li>\n    <li>\n        <span class="fa fa-li fa-gear"></span>\n        <span ng-include="\'extension/svn/buildRevisionLink/\' + property.value.buildRevisionLink.id + \'.tpl.html\'"></span>\n    </li>\n</ul>'),i.put("extension/svn/property/net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType.tpl.html",'<a href="{{property.value.url}}" target="_blank">\n    {{property.value.projectPath}}\n    @\n    {{property.value.configuration.name}}\n</a>'),
i.put("extension/svn/property/net.nemerosa.ontrack.extension.svn.property.SVNRevisionChangeLogIssueValidator.tpl.html",'<span ng-repeat="status in property.value.closedStatuses"><span class="label label-info">{{status}}</span>&nbsp;</span>'),i.put("extension/svn/property/net.nemerosa.ontrack.extension.svn.property.SVNSyncPropertyType.tpl.html",'<p>\n    <span ng-if="!property.value.interval">No automatic synchronisation.</span>\n    <span ng-if="property.value.interval">Synchronisation every {{property.value.interval}} minute(s).</span>\n</p>\n<p ng-if="property.value.override">\n    <span><b>Builds are overridden by the synchronisation.</b></span>\n</p>')}]);