/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import java.beans.ConstructorProperties;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RevisionPattern {
    private final String pattern;

    @ConstructorProperties(value={"pattern"})
    public RevisionPattern(String pattern) {
        if (!StringUtils.contains((CharSequence)pattern, (CharSequence)"{revision}")) {
            throw new IllegalArgumentException("Revision pattern must contain the {revision} token: " + pattern);
        }
        this.pattern = pattern;
    }

    public boolean isValidBuildName(String buildName) {
        return this.extractRevision(buildName).isPresent();
    }

    public OptionalLong extractRevision(String buildName) {
        String regex = this.getRegex();
        Matcher matcher = Pattern.compile(regex).matcher(buildName);
        if (matcher.matches()) {
            String token = matcher.group(1);
            return OptionalLong.of(Long.parseLong(token, 10));
        }
        return OptionalLong.empty();
    }

    private String getRegex() {
        return "^" + StringUtils.replace((String)StringUtils.replace((String)this.pattern, (String)"{revision}", (String)"(\\d+)"), (String)"*", (String)".*") + "$";
    }

    public RevisionPattern clone(Function<String, String> replacementFunction) {
        return new RevisionPattern(replacementFunction.apply(this.pattern));
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevisionPattern)) {
            return false;
        }
        RevisionPattern other = (RevisionPattern)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        return !(this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevisionPattern;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        return result;
    }

    public String toString() {
        return "RevisionPattern(pattern=" + this.getPattern() + ")";
    }
}

