/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.support;

import java.util.Optional;
import java.util.OptionalLong;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.db.TCopyEvent;
import net.nemerosa.ontrack.extension.svn.model.IndexableBuildSvnRevisionLink;
import net.nemerosa.ontrack.extension.svn.model.SVNLocation;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTagBasedSvnRevisionLink<T>
implements IndexableBuildSvnRevisionLink<T> {
    private final SVNService svnService;
    private final StructureService structureService;

    protected AbstractTagBasedSvnRevisionLink(SVNService svnService, StructureService structureService) {
        this.svnService = svnService;
        this.structureService = structureService;
    }

    @Override
    public OptionalLong getRevision(T data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        Optional<String> oTagPath = this.getTagPath(data, build, branchConfigurationProperty);
        if (oTagPath.isPresent()) {
            String tagPath = oTagPath.get();
            SVNRepository svnRepository = this.svnService.getRequiredSVNRepository(build.getBranch());
            TCopyEvent lastCopyEvent = this.svnService.getLastCopyEvent(svnRepository.getId(), tagPath, Long.MAX_VALUE);
            return lastCopyEvent != null ? OptionalLong.of(lastCopyEvent.getCopyFromRevision()) : OptionalLong.empty();
        }
        return OptionalLong.empty();
    }

    @Override
    public String getBuildPath(T data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.getTagPath(data, build, branchConfigurationProperty).get();
    }

    @Override
    public Optional<Build> getEarliestBuild(T data, Branch branch, SVNLocation location, SVNLocation firstCopy, SVNBranchConfigurationProperty branchConfigurationProperty) {
        if (firstCopy != null) {
            return this.getEarliestBuild(data, branch, firstCopy, branchConfigurationProperty);
        }
        return Optional.empty();
    }

    protected Optional<Build> getEarliestBuild(T data, Branch branch, SVNLocation location, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.extractBuildName(data, location.getPath(), branch, branchConfigurationProperty).flatMap(buildName -> this.structureService.findBuildByName(branch.getProject().getName(), branch.getName(), buildName));
    }

    protected Optional<String> getTagPath(T data, Build build, SVNBranchConfigurationProperty branchConfigurationProperty) {
        return this.getTagName(data, build.getName()).flatMap(tagName -> {
            SVNRepository svnRepository = this.svnService.getRequiredSVNRepository(build.getBranch());
            return this.svnService.getTagPathForTagName(svnRepository, branchConfigurationProperty.getCuredBranchPath(), (String)tagName);
        });
    }

    protected Optional<String> extractBuildName(T data, String path, Branch branch, SVNBranchConfigurationProperty branchConfigurationProperty) {
        SVNRepository svnRepository = this.svnService.getRequiredSVNRepository(branch);
        Optional<String> oBasePath = this.svnService.getBasePath(svnRepository, branchConfigurationProperty.getCuredBranchPath());
        if (!oBasePath.isPresent()) {
            return Optional.empty();
        }
        String basePath = oBasePath.get();
        String tagsBasePath = basePath + "/tags/";
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)tagsBasePath)) {
            String token = StringUtils.substringAfter((String)path, (String)tagsBasePath);
            String tagName = StringUtils.substringBefore((String)token, (String)"/");
            return this.getBuildName(data, tagName);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getBuildNameFromTagName(T data, String tagName) {
        return this.getBuildName(data, tagName);
    }

    protected abstract Optional<String> getBuildName(T var1, String var2);

    protected abstract Optional<String> getTagName(T var1, String var2);
}

