/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.service;

import java.time.LocalDateTime;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevision;

public final class SVNServiceUtils {
    private SVNServiceUtils() {
    }

    public static SVNChangeLogRevision createChangeLogRevision(SVNRepository repository, String path, int level, long revision, String message, String author, LocalDateTime revisionDate) {
        ConfiguredIssueService configuredIssueService = repository.getConfiguredIssueService();
        String formattedMessage = configuredIssueService != null ? configuredIssueService.formatIssuesInMessage(message) : message;
        String revisionUrl = repository.getRevisionBrowsingURL(revision);
        return new SVNChangeLogRevision(path, level, revision, author, revisionDate, message, revisionUrl, formattedMessage);
    }
}

