/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLog;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogIssueValidation;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.db.SVNIssueRevisionDao;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLog;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssue;
import net.nemerosa.ontrack.extension.svn.model.SVNHistory;
import net.nemerosa.ontrack.extension.svn.property.AbstractSVNChangeLogIssueValidator;
import net.nemerosa.ontrack.extension.svn.property.SVNRevisionChangeLogIssueValidatorConfig;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiStrings;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNRevisionChangeLogIssueValidator
extends AbstractSVNChangeLogIssueValidator<SVNRevisionChangeLogIssueValidatorConfig> {
    private final SVNIssueRevisionDao issueRevisionDao;

    @Autowired
    public SVNRevisionChangeLogIssueValidator(SVNExtensionFeature extensionFeature, PropertyService propertyService, SVNIssueRevisionDao issueRevisionDao) {
        super((ExtensionFeature)extensionFeature, propertyService);
        this.issueRevisionDao = issueRevisionDao;
    }

    public void validate(SCMChangeLog<SVNHistory> changeLog, SVNChangeLogIssue issue, SVNRevisionChangeLogIssueValidatorConfig validatorConfig) {
        OptionalLong lastRevision;
        SVNChangeLog svnChangeLog = (SVNChangeLog)changeLog;
        if (this.canApplyTo(svnChangeLog.getBranch()) && validatorConfig.getClosedStatuses().contains(issue.getIssue().getStatus().getName()) && (lastRevision = this.issueRevisionDao.findLastRevisionByIssue(svnChangeLog.getRepository().getId(), issue.getIssue().getKey())).isPresent()) {
            long maxRevision = Math.max(((SVNHistory)changeLog.getScmBuildFrom().getScm()).getRevision(), ((SVNHistory)changeLog.getScmBuildTo().getScm()).getRevision());
            if (lastRevision.getAsLong() > maxRevision) {
                issue.addValidations(Collections.singletonList(SCMChangeLogIssueValidation.error((String)String.format("Issue %s is closed (%s), but has been fixed outside this change log", issue.getIssue().getKey(), issue.getIssue().getStatus().getName()))));
            }
        }
    }

    public String getName() {
        return "Validator: closed issues";
    }

    public String getDescription() {
        return "Detects issues which are closed but with revisions outside of the revision log.";
    }

    public Form getEditionForm(ProjectEntity entity, SVNRevisionChangeLogIssueValidatorConfig value) {
        return Form.create().with((Field)((MultiStrings)((MultiStrings)MultiStrings.of((String)"closedStatuses").label("Closed statuses")).help("List of issue statuses that are considered as closed.")).value(value != null ? value.getClosedStatuses() : Collections.emptyList()));
    }

    public SVNRevisionChangeLogIssueValidatorConfig fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public SVNRevisionChangeLogIssueValidatorConfig fromStorage(JsonNode node) {
        return new SVNRevisionChangeLogIssueValidatorConfig(JsonUtils.getStringList((JsonNode)node, (String)"closedStatuses"));
    }

    public String getSearchKey(SVNRevisionChangeLogIssueValidatorConfig value) {
        return "";
    }

    public SVNRevisionChangeLogIssueValidatorConfig replaceValue(SVNRevisionChangeLogIssueValidatorConfig value, Function<String, String> replacementFunction) {
        return new SVNRevisionChangeLogIssueValidatorConfig(value.getClosedStatuses().stream().map(replacementFunction).collect(Collectors.toList()));
    }
}

