/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ConfigurationPropertyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNProjectConfigurationPropertyType
extends AbstractPropertyType<SVNProjectConfigurationProperty>
implements ConfigurationPropertyType<SVNConfiguration, SVNProjectConfigurationProperty> {
    private final SVNConfigurationService configurationService;

    @Autowired
    public SVNProjectConfigurationPropertyType(SVNExtensionFeature extensionFeature, SVNConfigurationService configurationService) {
        super((ExtensionFeature)extensionFeature);
        this.configurationService = configurationService;
    }

    public String getName() {
        return "SVN configuration";
    }

    public String getDescription() {
        return "Associates the project with a Subversion repository";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, SVNProjectConfigurationProperty value) {
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"configuration").label("Configuration")).help("SVN configuration to use to access the repository")).items(this.configurationService.getConfigurationDescriptors()).value(value != null ? value.getConfiguration().getName() : null)).with((Field)((Text)((Text)Text.of((String)"projectPath").label("Project path")).help("Path of the main project branch (trunk) in this configuration. The path is relative to the root of the repository.")).value((Object)(value != null ? value.getProjectPath() : "/project/trunk")));
    }

    public JsonNode forStorage(SVNProjectConfigurationProperty value) {
        return SVNProjectConfigurationPropertyType.format((Object)MapBuilder.params().with((Object)"configuration", (Object)value.getConfiguration().getName()).with((Object)"projectPath", (Object)value.getProjectPath()).get());
    }

    public SVNProjectConfigurationProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public SVNProjectConfigurationProperty fromStorage(JsonNode node) {
        String configurationName = node.path("configuration").asText();
        String projectPath = node.path("projectPath").asText();
        SVNConfiguration configuration = (SVNConfiguration)this.configurationService.getConfiguration(configurationName);
        this.validateNotBlank(projectPath, "The project path must not be empty");
        return new SVNProjectConfigurationProperty(configuration, projectPath);
    }

    public String getSearchKey(SVNProjectConfigurationProperty value) {
        return value.getConfiguration().getName();
    }

    public SVNProjectConfigurationProperty replaceValue(SVNProjectConfigurationProperty value, Function<String, String> replacementFunction) {
        return new SVNProjectConfigurationProperty((SVNConfiguration)this.configurationService.replaceConfiguration(value.getConfiguration(), replacementFunction), replacementFunction.apply(value.getProjectPath()));
    }
}

