/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.property;

import com.fasterxml.jackson.annotation.JsonIgnore;
import net.nemerosa.ontrack.extension.svn.model.BranchPathRequiredException;
import net.nemerosa.ontrack.model.structure.ServiceConfiguration;
import org.apache.commons.lang3.StringUtils;

public class SVNBranchConfigurationProperty {
    private final String branchPath;
    private final ServiceConfiguration buildRevisionLink;

    public SVNBranchConfigurationProperty(String branchPath, ServiceConfiguration buildRevisionLink) {
        if (StringUtils.isBlank((CharSequence)branchPath)) {
            throw new BranchPathRequiredException();
        }
        this.branchPath = branchPath;
        this.buildRevisionLink = buildRevisionLink;
    }

    @JsonIgnore
    public String getCuredBranchPath() {
        String trim = StringUtils.trim((String)this.branchPath);
        if ("/".equals(trim)) {
            return trim;
        }
        return StringUtils.stripEnd((String)trim, (String)"/");
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public ServiceConfiguration getBuildRevisionLink() {
        return this.buildRevisionLink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SVNBranchConfigurationProperty)) {
            return false;
        }
        SVNBranchConfigurationProperty other = (SVNBranchConfigurationProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$branchPath = this.getBranchPath();
        String other$branchPath = other.getBranchPath();
        if (this$branchPath == null ? other$branchPath != null : !this$branchPath.equals(other$branchPath)) {
            return false;
        }
        ServiceConfiguration this$buildRevisionLink = this.getBuildRevisionLink();
        ServiceConfiguration other$buildRevisionLink = other.getBuildRevisionLink();
        return !(this$buildRevisionLink == null ? other$buildRevisionLink != null : !this$buildRevisionLink.equals(other$buildRevisionLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SVNBranchConfigurationProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $branchPath = this.getBranchPath();
        result = result * 59 + ($branchPath == null ? 43 : $branchPath.hashCode());
        ServiceConfiguration $buildRevisionLink = this.getBuildRevisionLink();
        result = result * 59 + ($buildRevisionLink == null ? 43 : $buildRevisionLink.hashCode());
        return result;
    }

    public String toString() {
        return "SVNBranchConfigurationProperty(branchPath=" + this.getBranchPath() + ", buildRevisionLink=" + this.getBuildRevisionLink() + ")";
    }
}

