/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.svn.model.SVNReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lnet/nemerosa/ontrack/extension/svn/model/SVNHistory;", "", "()V", "references", "", "Lnet/nemerosa/ontrack/extension/svn/model/SVNReference;", "([Lnet/nemerosa/ontrack/extension/svn/model/SVNReference;)V", "", "(Ljava/util/List;)V", "getReferences", "()Ljava/util/List;", "revision", "", "getRevision", "()J", "add", "reference", "truncateAbove", "index", "", "ontrack-extension-svn"})
public final class SVNHistory {
    @NotNull
    private final List<SVNReference> references;

    @JsonIgnore
    public final long getRevision() {
        return this.references.get(0).getRevision();
    }

    @NotNull
    public final SVNHistory add(@NotNull SVNReference reference) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        return new SVNHistory(CollectionsKt.plus((Collection)this.references, (Object)reference));
    }

    @NotNull
    public final SVNHistory truncateAbove(int index) {
        return new SVNHistory(this.references.subList(index + 1, this.references.size()));
    }

    @NotNull
    public final List<SVNReference> getReferences() {
        return this.references;
    }

    public SVNHistory(@NotNull List<SVNReference> references) {
        Intrinsics.checkParameterIsNotNull(references, (String)"references");
        this.references = references;
    }

    public SVNHistory() {
        this(CollectionsKt.emptyList());
    }

    public SVNHistory(SVNReference ... references) {
        Intrinsics.checkParameterIsNotNull((Object)references, (String)"references");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(references, references.length)));
    }
}

