/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.sql.DataSource;
import net.nemerosa.ontrack.extension.svn.db.SVNRevisionDao;
import net.nemerosa.ontrack.extension.svn.db.TRevision;
import net.nemerosa.ontrack.extension.svn.model.SVNRevisionNotFoundException;
import net.nemerosa.ontrack.repository.support.AbstractJdbcRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SVNRevisionJdbcDao
extends AbstractJdbcRepository
implements SVNRevisionDao {
    public static final int MESSAGE_LENGTH = 500;

    @Autowired
    public SVNRevisionJdbcDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public long getLast(int repositoryId) {
        Long value = (Long)this.getNamedParameterJdbcTemplate().queryForObject("SELECT MAX(REVISION) FROM EXT_SVN_REVISION WHERE REPOSITORY = :repositoryId", (SqlParameterSource)this.params("repositoryId", repositoryId), Long.class);
        return value != null ? value : 0L;
    }

    @Override
    public void addRevision(int repositoryId, long revision, String author, LocalDateTime dateTime, String message, String branch) {
        NamedParameterJdbcTemplate t = this.getNamedParameterJdbcTemplate();
        MapSqlParameterSource params = this.params("revision", revision).addValue("repositoryId", (Object)repositoryId);
        t.update("DELETE FROM EXT_SVN_REVISION WHERE REPOSITORY =:repositoryId AND REVISION = :revision", (SqlParameterSource)params);
        t.update("INSERT INTO EXT_SVN_REVISION (REPOSITORY, REVISION, AUTHOR, CREATION, MESSAGE, BRANCH) VALUES (:repositoryId, :revision, :author, :creation, :message, :branch)", (SqlParameterSource)params.addValue("author", (Object)author).addValue("creation", (Object)SVNRevisionJdbcDao.dateTimeForDB((LocalDateTime)dateTime)).addValue("message", (Object)Objects.toString(StringUtils.abbreviate((String)message, (int)500), "")).addValue("branch", (Object)branch));
    }

    @Override
    public void addMergedRevisions(int repositoryId, long revision, List<Long> mergedRevisions) {
        NamedParameterJdbcTemplate t = this.getNamedParameterJdbcTemplate();
        for (long mergedRevision : mergedRevisions) {
            t.update("INSERT INTO EXT_SVN_MERGE_REVISION (REPOSITORY, REVISION, TARGET) VALUES (:repository, :mergedRevision, :revision)", (SqlParameterSource)this.params("mergedRevision", mergedRevision).addValue("repository", (Object)repositoryId).addValue("revision", (Object)revision));
        }
    }

    @Override
    public TRevision getLastRevision(int repositoryId) {
        return (TRevision)this.getFirstItem("SELECT * FROM EXT_SVN_REVISION WHERE REPOSITORY = :repositoryId ORDER BY REVISION DESC LIMIT 1", this.params("repositoryId", repositoryId), (rs, rowNum) -> this.toRevision(rs));
    }

    private TRevision toRevision(ResultSet rs) throws SQLException {
        return new TRevision(rs.getInt("REPOSITORY"), rs.getLong("REVISION"), rs.getString("AUTHOR"), SVNRevisionJdbcDao.dateTimeFromDB((String)rs.getString("CREATION")), rs.getString("MESSAGE"), rs.getString("BRANCH"));
    }

    @Override
    public TRevision get(int repositoryId, long revision) {
        try {
            return (TRevision)this.getNamedParameterJdbcTemplate().queryForObject("SELECT * FROM EXT_SVN_REVISION WHERE REPOSITORY = :repository AND REVISION = :revision", (SqlParameterSource)this.params("revision", revision).addValue("repository", (Object)repositoryId), (rs, rowNum) -> this.toRevision(rs));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new SVNRevisionNotFoundException(revision);
        }
    }

    @Override
    public List<Long> getMergesForRevision(int repositoryId, long revision) {
        return this.getNamedParameterJdbcTemplate().queryForList("SELECT TARGET FROM EXT_SVN_MERGE_REVISION WHERE REPOSITORY = :repository AND REVISION = :revision ORDER BY TARGET", (SqlParameterSource)this.params("revision", revision).addValue("repository", (Object)repositoryId), Long.class);
    }

    @Override
    public Optional<TRevision> getLastRevisionOnBranch(int repositoryId, String branch) {
        return this.getOptional("SELECT * FROM EXT_SVN_REVISION WHERE REPOSITORY = :repository AND BRANCH = :branch ORDER BY REVISION DESC LIMIT 1", this.params("repository", repositoryId).addValue("branch", (Object)branch), (rs, rowNum) -> this.toRevision(rs));
    }
}

