/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn.client;

import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNClientLogger
extends SVNDebugLogAdapter {
    private final Logger logger = LoggerFactory.getLogger(SVNClient.class);

    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        switch (logLevel.getName()) {
            case "SEVERE": {
                this.logger.error(String.format("[%s]", logType.getName()), th);
                break;
            }
            case "WARNING": {
                this.logger.warn(String.format("[%s]", logType.getName()), th);
                break;
            }
            case "INFO": {
                this.logger.info(String.format("[%s]", logType.getName()), th);
                break;
            }
            case "FINE": {
                this.logger.debug(String.format("[%s]", logType.getName()), th);
                break;
            }
            default: {
                this.logger.trace(String.format("[%s]", logType.getName()), th);
            }
        }
    }

    public void log(SVNLogType logType, String message, Level logLevel) {
        switch (logLevel.getName()) {
            case "SEVERE": {
                this.logger.error("[{}] {}", (Object)logType.getName(), (Object)message);
                break;
            }
            case "WARNING": {
                this.logger.warn("[{}] {}", (Object)logType.getName(), (Object)message);
                break;
            }
            case "INFO": {
                this.logger.info("[{}] {}", (Object)logType.getName(), (Object)message);
                break;
            }
            case "FINE": {
                this.logger.debug("[{}] {}", (Object)logType.getName(), (Object)message);
                break;
            }
            default: {
                this.logger.trace("[{}] {}", (Object)logType.getName(), (Object)message);
            }
        }
    }

    public void log(SVNLogType logType, String message, byte[] data) {
        try {
            String dataAsString = new String(data, "UTF-8");
            this.logger.trace("[{}][data] {}\n{}", new Object[]{logType.getName(), message, dataAsString});
        }
        catch (UnsupportedEncodingException e) {
            this.logger.trace("[{}][data] {}", (Object)logType.getName(), (Object)message);
        }
    }
}

