/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.model.BuildDiffRequest;
import net.nemerosa.ontrack.extension.api.model.FileDiffChangeLogRequest;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.export.ExportFormat;
import net.nemerosa.ontrack.extension.issues.export.ExportedIssues;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogIssue;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogUUIDException;
import net.nemerosa.ontrack.extension.scm.model.SCMDocumentNotFoundException;
import net.nemerosa.ontrack.extension.scm.service.SCMUtilsService;
import net.nemerosa.ontrack.extension.support.AbstractExtensionController;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.model.LastRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.OntrackSVNIssueInfo;
import net.nemerosa.ontrack.extension.svn.model.OntrackSVNRevisionInfo;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLog;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFile;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogFiles;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogIssues;
import net.nemerosa.ontrack.extension.svn.model.SVNChangeLogRevisions;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.model.SVNInfoService;
import net.nemerosa.ontrack.extension.svn.model.SVNSyncInfoStatus;
import net.nemerosa.ontrack.extension.svn.service.IndexationService;
import net.nemerosa.ontrack.extension.svn.service.SVNChangeLogService;
import net.nemerosa.ontrack.extension.svn.service.SVNConfigurationService;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.service.SVNSyncService;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.buildfilter.BuildDiff;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RestController
@RequestMapping(value={"extension/svn"})
public class SVNController
extends AbstractExtensionController<SVNExtensionFeature> {
    private final SVNConfigurationService svnConfigurationService;
    private final IndexationService indexationService;
    private final SVNChangeLogService changeLogService;
    private final IssueServiceRegistry issueServiceRegistry;
    private final SVNService svnService;
    private final SVNInfoService svnInfoService;
    private final SCMUtilsService scmService;
    private final SVNSyncService svnSyncService;
    private final SecurityService securityService;
    private final StructureService structureService;
    private final Cache logCache;

    @Autowired
    public SVNController(SVNExtensionFeature feature, SVNConfigurationService svnConfigurationService, IndexationService indexationService, SVNChangeLogService changeLogService, IssueServiceRegistry issueServiceRegistry, SVNService svnService, SVNInfoService svnInfoService, SCMUtilsService scmService, SVNSyncService svnSyncService, SecurityService securityService, StructureService structureService, CacheManager cacheManager) {
        super((ExtensionFeature)feature);
        this.svnConfigurationService = svnConfigurationService;
        this.indexationService = indexationService;
        this.changeLogService = changeLogService;
        this.issueServiceRegistry = issueServiceRegistry;
        this.svnService = svnService;
        this.svnInfoService = svnInfoService;
        this.scmService = scmService;
        this.svnSyncService = svnSyncService;
        this.securityService = securityService;
        this.structureService = structureService;
        this.logCache = cacheManager.getCache("svnChangeLog");
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resource<ExtensionFeatureDescription> getDescription() {
        return (Resource)Resource.of((Object)((SVNExtensionFeature)this.feature).getFeatureDescription(), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getDescription())).with("configurations", this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations()), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations"}, method={RequestMethod.GET})
    public Resources<SVNConfiguration> getConfigurations() {
        return (Resources)((Resources)Resources.of((Collection)this.svnConfigurationService.getConfigurations(), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations())).with("_create", this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationForm()))).with("_test", this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).testConfiguration(null)), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations/descriptors"}, method={RequestMethod.GET})
    public Resources<ConfigurationDescriptor> getConfigurationsDescriptors() {
        return Resources.of((Collection)this.svnConfigurationService.getConfigurationDescriptors(), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationsDescriptors()));
    }

    @RequestMapping(value={"configurations/test"}, method={RequestMethod.POST})
    public ConnectionResult testConfiguration(@RequestBody SVNConfiguration configuration) {
        return this.svnConfigurationService.test(configuration);
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.GET})
    public Form getConfigurationForm() {
        return SVNConfiguration.Companion.form(this.issueServiceRegistry.getAvailableIssueServiceConfigurations());
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.POST})
    public SVNConfiguration newConfiguration(@RequestBody SVNConfiguration configuration) {
        return (SVNConfiguration)this.svnConfigurationService.newConfiguration(configuration);
    }

    @RequestMapping(value={"configurations/{name:.*}"}, method={RequestMethod.GET})
    public SVNConfiguration getConfiguration(@PathVariable String name) {
        return (SVNConfiguration)this.svnConfigurationService.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name:.*}/indexation"}, method={RequestMethod.GET})
    @ResponseBody
    public LastRevisionInfo getLastRevisionInfo(@PathVariable String name) {
        return this.indexationService.getLastRevisionInfo(name);
    }

    @RequestMapping(value={"configurations/{name:.*}/indexation/latest"}, method={RequestMethod.POST})
    @ResponseBody
    public Ack indexFromLatest(@PathVariable String name) {
        return this.indexationService.indexFromLatest(name);
    }

    @RequestMapping(value={"configurations/{name:.*}/indexation/full"}, method={RequestMethod.POST})
    @ResponseBody
    public Ack full(@PathVariable String name) {
        return this.indexationService.reindex(name);
    }

    @RequestMapping(value={"configurations/{name:.*}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Ack deleteConfiguration(@PathVariable String name) {
        this.svnConfigurationService.deleteConfiguration(name);
        return Ack.OK;
    }

    @RequestMapping(value={"configurations/{name:.*}/update"}, method={RequestMethod.GET})
    public Form updateConfigurationForm(@PathVariable String name) {
        return ((SVNConfiguration)this.svnConfigurationService.getConfiguration(name)).asForm(this.issueServiceRegistry.getAvailableIssueServiceConfigurations());
    }

    @RequestMapping(value={"configurations/{name:.*}/update"}, method={RequestMethod.PUT})
    public SVNConfiguration updateConfiguration(@PathVariable String name, @RequestBody SVNConfiguration configuration) {
        this.svnConfigurationService.updateConfiguration(name, configuration);
        return this.getConfiguration(name);
    }

    @RequestMapping(value={"changelog/export/{branchId}/formats"}, method={RequestMethod.GET})
    public Resources<ExportFormat> changeLogExportFormats(@PathVariable ID branchId) {
        return Resources.of(this.changeLogService.changeLogExportFormats(branchId), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(SVNController.class))).changeLogExportFormats(branchId)));
    }

    @RequestMapping(value={"changelog/export"}, method={RequestMethod.GET})
    public ResponseEntity<String> changeLog(IssueChangeLogExportRequest request) {
        SVNChangeLog changeLog = this.changeLogService.changeLog((BuildDiffRequest)request);
        ConfiguredIssueService configuredIssueService = changeLog.getRepository().getConfiguredIssueService();
        if (configuredIssueService == null) {
            return new ResponseEntity((Object)"The branch is not configured for issues", HttpStatus.NO_CONTENT);
        }
        SVNChangeLogIssues changeLogIssues = this.changeLogService.getChangeLogIssues(changeLog);
        List issues = changeLogIssues.getList().stream().map(SCMChangeLogIssue::getIssue).collect(Collectors.toList());
        ExportedIssues exportedChangeLogIssues = configuredIssueService.getIssueServiceExtension().exportIssues(configuredIssueService.getIssueServiceConfiguration(), issues, request);
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", exportedChangeLogIssues.getFormat());
        return new ResponseEntity((Object)exportedChangeLogIssues.getContent(), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"changelog/diff"}, method={RequestMethod.GET})
    public ResponseEntity<String> diff(FileDiffChangeLogRequest request) {
        SVNChangeLog changeLog = this.changeLogService.changeLog((BuildDiffRequest)request);
        SVNChangeLogFiles changeLogFiles = this.changeLogService.getChangeLogFiles(changeLog);
        String diff = this.scmService.diff(changeLogFiles.getList(), request.getPatterns(), changeLogFile -> this.changeLogService.getDiff(changeLog.getRepository(), (SVNChangeLogFile)changeLogFile));
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.set("Content-Type", "text/plain");
        return new ResponseEntity((Object)diff, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"changelog"}, method={RequestMethod.GET})
    public BuildDiff changeLog(BuildDiffRequest request) {
        SVNChangeLog changeLog = this.changeLogService.changeLog(request);
        this.logCache.put((Object)changeLog.getUuid(), (Object)changeLog);
        return changeLog;
    }

    @RequestMapping(value={"changelog/{uuid}/revisions"}, method={RequestMethod.GET})
    public SVNChangeLogRevisions changeLogRevisions(@PathVariable String uuid) {
        SVNChangeLog changeLog = this.getChangeLog(uuid);
        SVNChangeLogRevisions revisions = changeLog.getRevisions();
        if (revisions != null) {
            return revisions;
        }
        revisions = this.changeLogService.getChangeLogRevisions(changeLog);
        this.logCache.put((Object)uuid, (Object)changeLog.withRevisions(revisions));
        return revisions;
    }

    @RequestMapping(value={"changelog/{uuid}/issues"}, method={RequestMethod.GET})
    public SVNChangeLogIssues changeLogIssues(@PathVariable String uuid) {
        SVNChangeLog changeLog = this.getChangeLog(uuid);
        SVNChangeLogIssues issues = changeLog.getIssues();
        if (issues != null) {
            return issues;
        }
        issues = this.changeLogService.getChangeLogIssues(changeLog);
        this.logCache.put((Object)uuid, (Object)changeLog.withIssues(issues));
        return issues;
    }

    @RequestMapping(value={"changelog/{uuid}/files"}, method={RequestMethod.GET})
    public SVNChangeLogFiles changeLogFiles(@PathVariable String uuid) {
        SVNChangeLog changeLog = this.getChangeLog(uuid);
        SVNChangeLogFiles files = changeLog.getFiles();
        if (files != null) {
            return files;
        }
        files = this.changeLogService.getChangeLogFiles(changeLog);
        this.logCache.put((Object)uuid, (Object)changeLog.withFiles(files));
        return files;
    }

    private SVNChangeLog getChangeLog(String uuid) {
        SVNChangeLog changeLog = (SVNChangeLog)((Object)this.logCache.get((Object)uuid, SVNChangeLog.class));
        if (changeLog != null) {
            return changeLog;
        }
        throw new SCMChangeLogUUIDException(uuid);
    }

    @RequestMapping(value={"configuration/{configuration:.*}/issue/{key}"}, method={RequestMethod.GET})
    public Resource<OntrackSVNIssueInfo> issueInfo(@PathVariable String configuration, @PathVariable String key) {
        return Resource.of((Object)this.svnInfoService.getIssueInfo(configuration, key), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).issueInfo(configuration, key))).withView(Build.class);
    }

    @RequestMapping(value={"configuration/{configuration:.*}/revision/{revision}"}, method={RequestMethod.GET})
    public Resource<OntrackSVNRevisionInfo> revisionInfo(@PathVariable String configuration, @PathVariable long revision) {
        return Resource.of((Object)this.svnInfoService.getOntrackRevisionInfo(this.svnService.getRepository(configuration), revision), (URI)this.uri(((SVNController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).revisionInfo(configuration, revision))).withView(Build.class);
    }

    @RequestMapping(value={"sync/{branchId}"}, method={RequestMethod.POST})
    public SVNSyncInfoStatus launchSync(@PathVariable ID branchId) {
        return this.svnSyncService.launchSync(branchId);
    }

    @RequestMapping(value={"download/{branchId}"})
    public ResponseEntity<String> download(@PathVariable ID branchId, String path) {
        return this.svnService.download(this.structureService.getBranch(branchId), path).map(ResponseEntity::ok).orElseThrow(() -> new SCMDocumentNotFoundException(path));
    }
}

