/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.support.ConfigurationConnectorStatusIndicator;
import net.nemerosa.ontrack.extension.svn.client.SVNClient;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.model.SVNConfiguration;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.extension.svn.support.SVNUtils;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import net.nemerosa.ontrack.model.support.Connector;
import net.nemerosa.ontrack.model.support.ConnectorDescription;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.tmatesoft.svn.core.SVNURL;

@Component
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/svn/SVNConnectorStatusIndicator;", "Lnet/nemerosa/ontrack/extension/support/ConfigurationConnectorStatusIndicator;", "Lnet/nemerosa/ontrack/extension/svn/model/SVNConfiguration;", "configurationService", "Lnet/nemerosa/ontrack/model/support/ConfigurationService;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "svnService", "Lnet/nemerosa/ontrack/extension/svn/service/SVNService;", "transactionService", "Lnet/nemerosa/ontrack/tx/TransactionService;", "svnClient", "Lnet/nemerosa/ontrack/extension/svn/client/SVNClient;", "(Lnet/nemerosa/ontrack/model/support/ConfigurationService;Lnet/nemerosa/ontrack/model/security/SecurityService;Lnet/nemerosa/ontrack/extension/svn/service/SVNService;Lnet/nemerosa/ontrack/tx/TransactionService;Lnet/nemerosa/ontrack/extension/svn/client/SVNClient;)V", "type", "", "getType", "()Ljava/lang/String;", "connect", "", "config", "connectorDescription", "Lnet/nemerosa/ontrack/model/support/ConnectorDescription;", "ontrack-extension-svn"})
public class SVNConnectorStatusIndicator
extends ConfigurationConnectorStatusIndicator<SVNConfiguration> {
    @NotNull
    private final String type = "svn";
    private final SVNService svnService;
    private final TransactionService transactionService;
    private final SVNClient svnClient;

    @NotNull
    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect(@NotNull SVNConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        SVNRepository repository = this.svnService.getRepository(config.getName());
        AutoCloseable autoCloseable = (AutoCloseable)this.transactionService.start();
        boolean bl = false;
        Throwable throwable = null;
        try {
            Transaction $noName_0 = (Transaction)autoCloseable;
            boolean bl2 = false;
            SVNURL url = SVNUtils.toURL(repository.getConfiguration().getUrl());
            long l = this.svnClient.getRepositoryRevision(repository, url);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    protected ConnectorDescription connectorDescription(@NotNull SVNConfiguration config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        return new ConnectorDescription(new Connector(this.getType(), config.getName()), config.getUrl());
    }

    public SVNConnectorStatusIndicator(@NotNull ConfigurationService<SVNConfiguration> configurationService, @NotNull SecurityService securityService, @NotNull SVNService svnService, @NotNull TransactionService transactionService, @NotNull SVNClient svnClient) {
        Intrinsics.checkParameterIsNotNull(configurationService, (String)"configurationService");
        Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
        Intrinsics.checkParameterIsNotNull((Object)svnService, (String)"svnService");
        Intrinsics.checkParameterIsNotNull((Object)transactionService, (String)"transactionService");
        Intrinsics.checkParameterIsNotNull((Object)svnClient, (String)"svnClient");
        super(configurationService, securityService);
        this.svnService = svnService;
        this.transactionService = transactionService;
        this.svnClient = svnClient;
        this.type = "svn";
    }
}

