/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import java.util.Optional;
import net.nemerosa.ontrack.extension.api.ProjectEntityActionExtension;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.security.BuildCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.support.Action;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SVNBranchSyncActionExtension
extends AbstractExtension
implements ProjectEntityActionExtension {
    private final PropertyService propertyService;
    private final SecurityService securityService;

    @Autowired
    public SVNBranchSyncActionExtension(SVNExtensionFeature extensionFeature, PropertyService propertyService, SecurityService securityService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.securityService = securityService;
    }

    public Optional<Action> getAction(ProjectEntity entity) {
        if (entity instanceof Branch && this.propertyService.hasProperty(entity, SVNBranchConfigurationPropertyType.class) && this.securityService.isProjectFunctionGranted(entity, BuildCreate.class)) {
            return Optional.of(Action.of((String)"svn-sync", (String)"SVN <-> Build sync", (String)String.format("sync/%d", entity.id()), (Object[])new Object[0]));
        }
        return Optional.empty();
    }
}

