/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.svn;

import java.util.Optional;
import net.nemerosa.ontrack.extension.api.EntityInformationExtension;
import net.nemerosa.ontrack.extension.api.model.EntityInformation;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.extension.svn.SVNExtensionFeature;
import net.nemerosa.ontrack.extension.svn.db.SVNRepository;
import net.nemerosa.ontrack.extension.svn.property.SVNBranchConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.svn.property.SVNProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.svn.service.SVNChangeLogService;
import net.nemerosa.ontrack.extension.svn.service.SVNService;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildSVNInformationExtension
extends AbstractExtension
implements EntityInformationExtension {
    private final PropertyService propertyService;
    private final SVNService svnService;
    private final SVNChangeLogService svnChangeLogService;
    private final TransactionService transactionService;

    @Autowired
    public BuildSVNInformationExtension(SVNExtensionFeature extensionFeature, PropertyService propertyService, SVNService svnService, SVNChangeLogService svnChangeLogService, TransactionService transactionService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.svnService = svnService;
        this.svnChangeLogService = svnChangeLogService;
        this.transactionService = transactionService;
    }

    public Optional<EntityInformation> getInformation(ProjectEntity entity) {
        if (entity instanceof Build) {
            Build build = (Build)entity;
            Property branchConfigurationProperty = this.propertyService.getProperty((ProjectEntity)build.getBranch(), SVNBranchConfigurationPropertyType.class);
            Property projectConfigurationProperty = this.propertyService.getProperty((ProjectEntity)build.getBranch().getProject(), SVNProjectConfigurationPropertyType.class);
            if (branchConfigurationProperty.isEmpty() || projectConfigurationProperty.isEmpty()) {
                return Optional.empty();
            }
            SVNRepository repository = this.svnService.getRepository(((SVNProjectConfigurationProperty)projectConfigurationProperty.getValue()).getConfiguration().getName());
            try (Transaction ignored = this.transactionService.start();){
                Optional<EntityInformation> optional = Optional.of(new EntityInformation((EntityInformationExtension)this, (Object)this.svnChangeLogService.getBuildSVNHistory(repository, build)));
                return optional;
            }
        }
        return Optional.empty();
    }
}

