/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureOptions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtensionFeature
implements ExtensionFeature {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionFeature.class);
    public static final String VERSION_NONE = "none";
    private final String id;
    private final String name;
    private final String description;
    private final String version;
    private final ExtensionFeatureOptions options;

    public AbstractExtensionFeature(String id, String name, String description) {
        this(id, name, description, ExtensionFeatureOptions.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractExtensionFeature(String id, String name, String description, ExtensionFeatureOptions options) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.options = options;
        String path = String.format("/META-INF/ontrack/extension/%s.properties", id);
        logger.info("[extension][{}] Loading meta information at {}", (Object)id, (Object)path);
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in != null) {
            try {
                try {
                    Properties properties = new Properties();
                    properties.load(in);
                    String value = properties.getProperty("version");
                    if (StringUtils.isNotBlank((CharSequence)value)) {
                        this.version = value;
                    }
                    logger.debug("[extension][{}] No version found in {} - using default version", (Object)id, (Object)path);
                    this.version = VERSION_NONE;
                }
                finally {
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(String.format("[extension][%s] Cannot read resource at %s", id, path), ex);
            }
        } else {
            logger.debug("[extension][{}] No meta information found at {} - using defaults", (Object)id, (Object)path);
            this.version = VERSION_NONE;
        }
        logger.info("[extension][{}] Version = {}", (Object)id, (Object)this.version);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public ExtensionFeatureOptions getOptions() {
        return this.options;
    }
}

