/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common._KTUtilsKt;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.extension.stale.StaleBranchCheck;
import net.nemerosa.ontrack.extension.stale.StaleBranchStatus;
import net.nemerosa.ontrack.extension.stale.StaleJobService;
import net.nemerosa.ontrack.extension.stale.StaleJobServiceImpl;
import net.nemerosa.ontrack.job.Job;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobRegistration;
import net.nemerosa.ontrack.job.JobRun;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8RX\u0092\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lnet/nemerosa/ontrack/extension/stale/StaleJobServiceImpl;", "Lnet/nemerosa/ontrack/extension/stale/StaleJobService;", "extensionManager", "Lnet/nemerosa/ontrack/extension/api/ExtensionManager;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "(Lnet/nemerosa/ontrack/extension/api/ExtensionManager;Lnet/nemerosa/ontrack/model/structure/StructureService;)V", "checks", "", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchCheck;", "getChecks", "()Ljava/util/Set;", "checks$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "collectJobRegistrations", "Ljava/util/stream/Stream;", "Lnet/nemerosa/ontrack/job/JobRegistration;", "createStaleJob", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "detectAndManageStaleBranch", "", "branch", "Lnet/nemerosa/ontrack/model/structure/Branch;", "lastBuild", "Lnet/nemerosa/ontrack/model/structure/Build;", "detectAndManageStaleBranches", "runListener", "Lnet/nemerosa/ontrack/job/JobRunListener;", "getStaleJobKey", "Lnet/nemerosa/ontrack/job/JobKey;", "isProjectEligible", "", "Companion", "ontrack-extension-stale"})
public class StaleJobServiceImpl
implements StaleJobService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy checks$delegate;
    @NotNull
    private static final JobType STALE_BRANCH_JOB = JobCategory.Companion.of("cleanup").withName("Cleanup").getType("stale-branches").withName("Stale branches cleanup");

    public StaleJobServiceImpl(@NotNull ExtensionManager extensionManager, @NotNull StructureService structureService) {
        Intrinsics.checkNotNullParameter((Object)extensionManager, (String)"extensionManager");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        this.structureService = structureService;
        Logger logger = LoggerFactory.getLogger(StaleJobServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(StaleJobServiceImpl::class.java)");
        this.logger = logger;
        this.checks$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends StaleBranchCheck>>(extensionManager){
            final /* synthetic */ ExtensionManager $extensionManager;
            {
                this.$extensionManager = $extensionManager;
                super(0);
            }

            @NotNull
            public final Set<StaleBranchCheck> invoke() {
                Collection collection = this.$extensionManager.getExtensions(StaleBranchCheck.class);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"extensionManager.getExte\u2026eBranchCheck::class.java)");
                return CollectionsKt.toSet((Iterable)collection);
            }
        }));
    }

    private Set<StaleBranchCheck> getChecks() {
        Lazy lazy = this.checks$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Stream<JobRegistration> collectJobRegistrations() {
        void $this$mapTo$iv$iv;
        Project project;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.structureService.getProjectList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            project = (Project)element$iv$iv;
            boolean bl = false;
            if (!this.isProjectEligible(project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createStaleJob(project));
        }
        Stream<JobRegistration> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"structureService.project\u2026                .stream()");
        return stream;
    }

    private boolean isProjectEligible(Project project) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getChecks();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StaleBranchCheck it = (StaleBranchCheck)element$iv;
                    boolean bl2 = false;
                    if (!it.isProjectEligible(project)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    protected JobRegistration createStaleJob(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new JobRegistration(new Job(this, project){
            final /* synthetic */ StaleJobServiceImpl this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            @NotNull
            public JobKey getKey() {
                return this.this$0.getStaleJobKey(this.$project);
            }

            @NotNull
            public JobRun getTask() {
                return arg_0 -> createStaleJob.1.getTask$lambda-0(this.this$0, this.$project, arg_0);
            }

            @NotNull
            public String getDescription() {
                return "Detection and management of stale branches for " + this.$project.getName();
            }

            public boolean isDisabled() {
                return this.$project.isDisabled();
            }

            public boolean isValid() {
                return StaleJobServiceImpl.access$isProjectEligible(this.this$0, this.$project);
            }

            private static final void getTask$lambda-0(StaleJobServiceImpl this$0, Project $project, JobRunListener runListener) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)runListener, (String)"runListener");
                this$0.detectAndManageStaleBranches(runListener, $project);
            }
        }, Schedule.EVERY_DAY);
    }

    @NotNull
    protected JobKey getStaleJobKey(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return STALE_BRANCH_JOB.getKey(project.getId().toString());
    }

    @Override
    public void detectAndManageStaleBranches(@NotNull JobRunListener runListener, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)runListener, (String)"runListener");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.isProjectEligible(project)) {
            Iterable $this$forEach$iv = this.structureService.getBranchesForProject(project.getId());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Branch branch = (Branch)element$iv;
                boolean bl = false;
                Build lastBuild = (Build)_KTUtilsKt.getOrNull((Optional)this.structureService.getLastBuild(branch.getId()));
                this.detectAndManageStaleBranch(branch, lastBuild);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void detectAndManageStaleBranch(@NotNull Branch branch, @Nullable Build lastBuild) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        this.logger.debug("[{}] Scanning branch for staleness", (Object)branch.getEntityDisplayName());
        Iterable iterable = this.getChecks();
        Enum initial$iv = null;
        boolean $i$f$fold = false;
        Enum accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            StaleBranchStatus staleBranchStatus;
            StaleBranchCheck staleBranchCheck = (StaleBranchCheck)element$iv;
            Enum acc = accumulator$iv;
            boolean bl = false;
            Enum enum_ = acc;
            switch (enum_ == null ? -1 : WhenMappings.$EnumSwitchMapping$0[enum_.ordinal()]) {
                case -1: {
                    void check;
                    staleBranchStatus = check.getBranchStaleness(branch, lastBuild);
                    break;
                }
                case 1: {
                    staleBranchStatus = StaleBranchStatus.KEEP;
                    break;
                }
                default: {
                    void check;
                    staleBranchStatus = StaleBranchStatus.Companion.min((StaleBranchStatus)acc, check.getBranchStaleness(branch, lastBuild));
                }
            }
            accumulator$iv = staleBranchStatus;
        }
        Enum status = accumulator$iv;
        this.logger.debug("[{}] Branch staleness status: {}", (Object)branch.getEntityDisplayName(), status);
        Enum enum_ = status;
        switch (enum_ == null ? -1 : WhenMappings.$EnumSwitchMapping$0[enum_.ordinal()]) {
            case 2: {
                this.structureService.deleteBranch(branch.getId());
                break;
            }
            case 3: {
                if (branch.isDisabled()) break;
                this.structureService.disableBranch(branch);
            }
        }
    }

    public static final /* synthetic */ boolean access$isProjectEligible(StaleJobServiceImpl $this, Project project) {
        return $this.isProjectEligible(project);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/nemerosa/ontrack/extension/stale/StaleJobServiceImpl$Companion;", "", "()V", "STALE_BRANCH_JOB", "Lnet/nemerosa/ontrack/job/JobType;", "getSTALE_BRANCH_JOB", "()Lnet/nemerosa/ontrack/job/JobType;", "ontrack-extension-stale"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobType getSTALE_BRANCH_JOB() {
            return STALE_BRANCH_JOB;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StaleBranchStatus.values().length];
            nArray[StaleBranchStatus.KEEP.ordinal()] = 1;
            nArray[StaleBranchStatus.DELETE.ordinal()] = 2;
            nArray[StaleBranchStatus.DISABLE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

