/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.AbstractField;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.MultiStrings;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J$\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00022\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lnet/nemerosa/ontrack/extension/stale/StalePropertyType;", "Lnet/nemerosa/ontrack/extension/support/AbstractPropertyType;", "Lnet/nemerosa/ontrack/extension/stale/StaleProperty;", "extensionFeature", "Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;", "(Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;)V", "canEdit", "", "entity", "Lnet/nemerosa/ontrack/model/structure/ProjectEntity;", "securityService", "Lnet/nemerosa/ontrack/model/security/SecurityService;", "canView", "fromClient", "node", "Lcom/fasterxml/jackson/databind/JsonNode;", "fromStorage", "getDescription", "", "getEditionForm", "Lnet/nemerosa/ontrack/model/form/Form;", "value", "getName", "getSupportedEntityTypes", "", "Lnet/nemerosa/ontrack/model/structure/ProjectEntityType;", "replaceValue", "replacementFunction", "Ljava/util/function/Function;", "ontrack-extension-stale"})
public class StalePropertyType
extends AbstractPropertyType<StaleProperty> {
    public StalePropertyType(@NotNull StaleExtensionFeature extensionFeature) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionFeature), (String)"extensionFeature");
        super((ExtensionFeature)extensionFeature);
    }

    @NotNull
    public String getName() {
        return "Stale branches";
    }

    @NotNull
    public String getDescription() {
        return "Allows to disable or delete stale branches";
    }

    @NotNull
    public Set<ProjectEntityType> getSupportedEntityTypes() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)ProjectEntityType.PROJECT);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(ProjectEntityType.PROJECT)");
        return enumSet;
    }

    public boolean canEdit(@NotNull ProjectEntity entity, @NotNull SecurityService securityService) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(@NotNull ProjectEntity entity, @NotNull SecurityService securityService) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        return true;
    }

    @NotNull
    public Form getEditionForm(@NotNull ProjectEntity entity, @Nullable StaleProperty value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Form form = Form.Companion.create();
        StaleProperty staleProperty = value;
        AbstractField abstractField = ((Int)((Int)Int.of((String)"disablingDuration").label("Disabling branches after N (days)")).min(0).help("Number of days of inactivity after a branch is disabled. 0 means that the branch won't ever be disabled automatically.")).value((Object)(staleProperty != null ? staleProperty.getDisablingDuration() : 0));
        Intrinsics.checkNotNullExpressionValue((Object)abstractField, (String)"of(\"disablingDuration\")\n\u2026?.disablingDuration ?: 0)");
        Form form2 = form.with((Field)abstractField);
        AbstractField abstractField2 = ((Int)((Int)Int.of((String)"deletingDuration").label("Deleting branches after N (days) more")).min(0).help("Number of days of inactivity after a branch is deleted, after it has beendisabled automatically. 0 means that the branch won't ever be deleted automatically.")).value((Object)((object = value) != null && (object = ((StaleProperty)object).getDeletingDuration()) != null ? (Integer)object : 0));
        Intrinsics.checkNotNullExpressionValue((Object)abstractField2, (String)"of(\"deletingDuration\")\n \u2026e?.deletingDuration ?: 0)");
        Form form3 = form2.with((Field)abstractField2);
        MultiStrings multiStrings = (MultiStrings)((MultiStrings)MultiStrings.of((String)"promotionsToKeep").label("Promotions to keep")).help("List of promotion levels which prevent a branch to be disabled or deleted");
        Object object2 = value;
        if (object2 == null || (object2 = ((StaleProperty)object2).getPromotionsToKeep()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        AbstractField abstractField3 = multiStrings.value(object2);
        Intrinsics.checkNotNullExpressionValue((Object)abstractField3, (String)"of(\"promotionsToKeep\")\n \u2026Keep ?: emptyList<Any>())");
        Form form4 = form3.with((Field)abstractField3);
        StaleProperty staleProperty2 = value;
        AbstractField abstractField4 = ((Text)((Text)Text.of((String)"includes").label("Exclude branches")).help("Regular expression to identify branches which will never be disabled not deleted")).value((Object)(staleProperty2 != null ? staleProperty2.getIncludes() : null));
        Intrinsics.checkNotNullExpressionValue((Object)abstractField4, (String)"of(StaleProperty::includ\u2026  .value(value?.includes)");
        Form form5 = form4.with((Field)abstractField4);
        StaleProperty staleProperty3 = value;
        AbstractField abstractField5 = ((Text)((Text)Text.of((String)"excludes").label("... but")).help("Can define a regular expression for exceptions to the previous rule")).value((Object)(staleProperty3 != null ? staleProperty3.getExcludes() : null));
        Intrinsics.checkNotNullExpressionValue((Object)abstractField5, (String)"of(StaleProperty::exclud\u2026  .value(value?.excludes)");
        return form5.with((Field)abstractField5);
    }

    @NotNull
    public StaleProperty fromClient(@NotNull JsonNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.fromStorage(node);
    }

    @NotNull
    public StaleProperty fromStorage(@NotNull JsonNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object = AbstractPropertyType.parse((JsonNode)node, StaleProperty.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(node, StaleProperty::class.java)");
        return (StaleProperty)object;
    }

    @NotNull
    public StaleProperty replaceValue(@NotNull StaleProperty value, @NotNull Function<String, String> replacementFunction) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(replacementFunction, (String)"replacementFunction");
        return value;
    }
}

