/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.stale.StaleBranchCheck;
import net.nemerosa.ontrack.extension.stale.StaleBranchStatus;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.stale.StalePropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/stale/PropertyBasedStaleBranchCheck;", "Lnet/nemerosa/ontrack/extension/support/AbstractExtension;", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchCheck;", "extensionFeature", "Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;", "propertyService", "Lnet/nemerosa/ontrack/model/structure/PropertyService;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "(Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;Lnet/nemerosa/ontrack/model/structure/PropertyService;Lnet/nemerosa/ontrack/model/structure/StructureService;)V", "logger", "Lorg/slf4j/Logger;", "getBranchStaleness", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchStatus;", "branch", "Lnet/nemerosa/ontrack/model/structure/Branch;", "lastBuild", "Lnet/nemerosa/ontrack/model/structure/Build;", "isBranchEligible", "", "isProjectEligible", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "ontrack-extension-stale"})
public class PropertyBasedStaleBranchCheck
extends AbstractExtension
implements StaleBranchCheck {
    @NotNull
    private final PropertyService propertyService;
    @NotNull
    private final StructureService structureService;
    @NotNull
    private final Logger logger;

    public PropertyBasedStaleBranchCheck(@NotNull StaleExtensionFeature extensionFeature, @NotNull PropertyService propertyService, @NotNull StructureService structureService) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionFeature), (String)"extensionFeature");
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.structureService = structureService;
        Logger logger = LoggerFactory.getLogger(PropertyBasedStaleBranchCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PropertyBasedS\u2026eBranchCheck::class.java)");
        this.logger = logger;
    }

    @Override
    public boolean isProjectEligible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class);
    }

    @Override
    public boolean isBranchEligible(@NotNull Branch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return true;
    }

    @Override
    @Nullable
    public StaleBranchStatus getBranchStaleness(@NotNull Branch branch, @Nullable Build lastBuild) {
        LocalDateTime lastTime;
        Signature signature;
        Regex excludesRegex;
        Regex regex;
        String string;
        CharSequence charSequence;
        Object it2;
        boolean bl;
        String string2;
        Regex regex2;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        StaleProperty staleProperty = (StaleProperty)this.propertyService.getProperty((ProjectEntity)branch.getProject(), StalePropertyType.class).getValue();
        if (staleProperty == null) {
            return null;
        }
        StaleProperty property = staleProperty;
        int disablingDuration = property.getDisablingDuration();
        Integer deletionDuration = property.getDeletingDuration();
        List<String> promotionsToKeep = property.getPromotionsToKeep();
        String string3 = property.getIncludes();
        if (string3 == null) {
            regex2 = null;
        } else {
            string2 = string3;
            boolean bl2 = false;
            bl = false;
            it2 = string2;
            boolean bl3 = false;
            charSequence = (CharSequence)it2;
            boolean bl4 = false;
            String string4 = string = !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
            if (string == null) {
                regex2 = null;
            } else {
                string2 = string;
                bl2 = false;
                regex2 = new Regex(string2);
            }
        }
        Regex includesRegex = regex2;
        string = property.getExcludes();
        if (string == null) {
            regex = null;
        } else {
            String string5 = string;
            bl = false;
            boolean it2 = false;
            String it32 = string5;
            boolean bl5 = false;
            CharSequence charSequence2 = it32;
            boolean bl6 = false;
            String string6 = string2 = !StringsKt.isBlank((CharSequence)charSequence2) ? string5 : null;
            if (string2 == null) {
                regex = null;
            } else {
                string5 = string2;
                bl = false;
                regex = excludesRegex = new Regex(string5);
            }
        }
        if (disablingDuration <= 0) {
            this.logger.debug("[{}] No disabling time being set - exiting.", (Object)branch.getEntityDisplayName());
            return null;
        }
        LocalDateTime now = Time.now();
        LocalDateTime localDateTime = now.minusDays(disablingDuration);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now.minusDays(disablingDuration.toLong())");
        LocalDateTime disablingTime = localDateTime;
        LocalDateTime deletionTime = deletionDuration != null && deletionDuration > 0 ? disablingTime.minusDays(deletionDuration.intValue()) : null;
        this.logger.debug("[{}] Disabling time: {}", (Object)branch.getEntityDisplayName(), (Object)disablingTime);
        this.logger.debug("[{}] Deletion time: {}", (Object)branch.getEntityDisplayName(), (Object)deletionTime);
        Set promotionsToProtect = promotionsToKeep != null ? (Set)new HashSet(promotionsToKeep) : SetsKt.emptySet();
        it2 = promotionsToProtect;
        boolean it32 = false;
        if (!it2.isEmpty()) {
            boolean isProtected;
            block16: {
                boolean bl7;
                List it32 = this.structureService.getBranchStatusView(branch).getPromotions();
                Intrinsics.checkNotNullExpressionValue((Object)it32, (String)"structureService.getBran\u2026usView(branch).promotions");
                List lastPromotions = it32;
                Iterable $this$any$iv = lastPromotions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PromotionView promotionView = (PromotionView)element$iv;
                        boolean bl8 = false;
                        boolean bl9 = promotionView.getPromotionRun() != null && promotionsToProtect.contains(promotionView.getPromotionLevel().getName());
                        if (!bl9) continue;
                        bl7 = true;
                        break block16;
                    }
                    bl7 = isProtected = false;
                }
            }
            if (isProtected) {
                this.logger.debug("[{}] Branch is promoted and is not eligible for staleness", (Object)branch.getEntityDisplayName());
                return StaleBranchStatus.KEEP;
            }
        }
        if (includesRegex != null && includesRegex.matches((CharSequence)branch.getName()) && (excludesRegex == null || !excludesRegex.matches((CharSequence)branch.getName()))) {
            this.logger.debug("[{}] Branch is protected by includes/excludes rule", (Object)branch.getEntityDisplayName());
            return StaleBranchStatus.KEEP;
        }
        charSequence = lastBuild;
        LocalDateTime localDateTime2 = charSequence == null ? null : ((signature = charSequence.getSignature()) == null ? null : signature.getTime());
        LocalDateTime localDateTime3 = lastTime = localDateTime2 == null ? branch.getSignature().getTime() : localDateTime2;
        return deletionTime != null && deletionTime.compareTo(lastTime) > 0 ? StaleBranchStatus.DELETE : (disablingTime.compareTo(lastTime) > 0 && !branch.isDisabled() ? StaleBranchStatus.DISABLE : (StaleBranchStatus)null);
    }
}

