/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.stale.StaleBranchCheck;
import net.nemerosa.ontrack.extension.stale.StaleBranchStatus;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.stale.StalePropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/stale/PropertyBasedStaleBranchCheck;", "Lnet/nemerosa/ontrack/extension/support/AbstractExtension;", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchCheck;", "extensionFeature", "Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;", "propertyService", "Lnet/nemerosa/ontrack/model/structure/PropertyService;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "(Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;Lnet/nemerosa/ontrack/model/structure/PropertyService;Lnet/nemerosa/ontrack/model/structure/StructureService;)V", "logger", "Lorg/slf4j/Logger;", "getBranchStaleness", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchStatus;", "branch", "Lnet/nemerosa/ontrack/model/structure/Branch;", "lastBuild", "Lnet/nemerosa/ontrack/model/structure/Build;", "isBranchEligible", "", "isProjectEligible", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "ontrack-extension-stale"})
public class PropertyBasedStaleBranchCheck
extends AbstractExtension
implements StaleBranchCheck {
    private final Logger logger;
    private final PropertyService propertyService;
    private final StructureService structureService;

    @Override
    public boolean isProjectEligible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class);
    }

    @Override
    public boolean isBranchEligible(@NotNull Branch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public StaleBranchStatus getBranchStaleness(@NotNull Branch branch, @Nullable Build lastBuild) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        v0 = (StaleProperty)this.propertyService.getProperty((ProjectEntity)branch.getProject(), StalePropertyType.class).getValue();
        if (v0 == null) {
            return null;
        }
        property = v0;
        disablingDuration = property.getDisablingDuration();
        deletionDuration = property.getDeletingDuration();
        promotionsToKeep = property.getPromotionsToKeep();
        v1 = property.getIncludes();
        if (v1 == null) ** GOTO lbl-1000
        var8_7 = v1;
        var9_8 = false;
        var10_11 = false;
        it = var8_7;
        $i$a$-takeIf-PropertyBasedStaleBranchCheck$getBranchStaleness$includesRegex$1 = false;
        var13_19 = it;
        var14_22 = false;
        v1 = StringsKt.isBlank((CharSequence)var13_19) == false != false ? var8_7 : null;
        if (v1 != null) {
            var8_7 = v1;
            var9_8 = false;
            v2 = new Regex(var8_7);
        } else lbl-1000:
        // 2 sources

        {
            v2 = includesRegex = null;
        }
        if ((v3 = property.getExcludes()) == null) ** GOTO lbl-1000
        var9_9 = v3;
        var10_11 = false;
        it = false;
        it = var9_9;
        $i$a$-takeIf-PropertyBasedStaleBranchCheck$getBranchStaleness$excludesRegex$1 = false;
        var14_23 = it;
        var15_26 = false;
        v3 = StringsKt.isBlank((CharSequence)var14_23) == false != false ? var9_9 : null;
        if (v3 != null) {
            var9_9 = v3;
            var10_11 = false;
            v4 = new Regex(var9_9);
        } else lbl-1000:
        // 2 sources

        {
            v4 = excludesRegex = null;
        }
        if (disablingDuration <= 0) {
            this.logger.debug("[{}] No disabling time being set - exiting.", (Object)branch.getEntityDisplayName());
            return null;
        }
        now = Time.now();
        v5 = now.minusDays(disablingDuration);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"now.minusDays(disablingDuration.toLong())");
        disablingTime = v5;
        deletionTime = deletionDuration != null && deletionDuration > 0 ? disablingTime.minusDays(deletionDuration.intValue()) : null;
        this.logger.debug("[{}] Disabling time: {}", (Object)branch.getEntityDisplayName(), (Object)disablingTime);
        this.logger.debug("[{}] Deletion time: {}", (Object)branch.getEntityDisplayName(), (Object)deletionTime);
        promotionsToProtect = promotionsToKeep != null ? (Set)new HashSet<E>(promotionsToKeep) : SetsKt.emptySet();
        $i$a$-takeIf-PropertyBasedStaleBranchCheck$getBranchStaleness$excludesRegex$1 = promotionsToProtect;
        var14_24 = false;
        if ($i$a$-takeIf-PropertyBasedStaleBranchCheck$getBranchStaleness$excludesRegex$1.isEmpty() == false) {
            block13: {
                v6 = this.structureService.getBranchStatusView(branch).getPromotions();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"structureService.getBran\u2026usView(branch).promotions");
                lastPromotions = v6;
                $this$any$iv = lastPromotions;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v7 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        promotionView = (PromotionView)element$iv;
                        $i$a$-any-PropertyBasedStaleBranchCheck$getBranchStaleness$isProtected$1 = false;
                        if (!(promotionView.getPromotionRun() != null && promotionsToProtect.contains(promotionView.getPromotionLevel().getName()) != false)) continue;
                        v7 = true;
                        break block13;
                    }
                    v7 = isProtected = false;
                }
            }
            if (isProtected) {
                this.logger.debug("[{}] Branch is promoted and is not eligible for staleness", (Object)branch.getEntityDisplayName());
                return StaleBranchStatus.KEEP;
            }
        }
        if (includesRegex != null && includesRegex.matches((CharSequence)branch.getName()) && (excludesRegex == null || !excludesRegex.matches((CharSequence)branch.getName()))) {
            this.logger.debug("[{}] Branch is protected by includes/excludes rule", (Object)branch.getEntityDisplayName());
            return StaleBranchStatus.KEEP;
        }
        v8 /* !! */  = lastBuild;
        if (v8 /* !! */  == null || (v8 /* !! */  = v8 /* !! */ .getSignature()) == null || (v8 /* !! */  = v8 /* !! */ .getTime()) == null) {
            v8 /* !! */  = lastTime /* !! */  = branch.getSignature().getTime();
        }
        return deletionTime != null && deletionTime.compareTo((ChronoLocalDateTime)lastTime /* !! */ ) > 0 ? StaleBranchStatus.DELETE : (disablingTime.compareTo((ChronoLocalDateTime)lastTime /* !! */ ) > 0 && branch.isDisabled() == false ? StaleBranchStatus.DISABLE : null);
    }

    public PropertyBasedStaleBranchCheck(@NotNull StaleExtensionFeature extensionFeature, @NotNull PropertyService propertyService, @NotNull StructureService structureService) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionFeature), (String)"extensionFeature");
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.structureService = structureService;
        Logger logger = LoggerFactory.getLogger(PropertyBasedStaleBranchCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026eBranchCheck::class.java)");
        this.logger = logger;
    }
}

