/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.stale.StaleBranchCheck;
import net.nemerosa.ontrack.extension.stale.StaleBranchStatus;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.stale.StalePropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PromotionView;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/stale/PropertyBasedStaleBranchCheck;", "Lnet/nemerosa/ontrack/extension/support/AbstractExtension;", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchCheck;", "extensionFeature", "Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;", "propertyService", "Lnet/nemerosa/ontrack/model/structure/PropertyService;", "structureService", "Lnet/nemerosa/ontrack/model/structure/StructureService;", "(Lnet/nemerosa/ontrack/extension/stale/StaleExtensionFeature;Lnet/nemerosa/ontrack/model/structure/PropertyService;Lnet/nemerosa/ontrack/model/structure/StructureService;)V", "logger", "Lorg/slf4j/Logger;", "getBranchStaleness", "Lnet/nemerosa/ontrack/extension/stale/StaleBranchStatus;", "branch", "Lnet/nemerosa/ontrack/model/structure/Branch;", "lastBuild", "Lnet/nemerosa/ontrack/model/structure/Build;", "isBranchEligible", "", "isProjectEligible", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "ontrack-extension-stale"})
public class PropertyBasedStaleBranchCheck
extends AbstractExtension
implements StaleBranchCheck {
    private final Logger logger;
    private final PropertyService propertyService;
    private final StructureService structureService;

    @Override
    public boolean isProjectEligible(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class);
    }

    @Override
    public boolean isBranchEligible(@NotNull Branch branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return true;
    }

    @Override
    @Nullable
    public StaleBranchStatus getBranchStaleness(@NotNull Branch branch, @Nullable Build lastBuild) {
        Object lastTime;
        boolean isProtected;
        LocalDateTime deletionTime;
        LocalDateTime disablingTime;
        block7: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            StaleProperty staleProperty = (StaleProperty)this.propertyService.getProperty((ProjectEntity)branch.getProject(), StalePropertyType.class).getValue();
            if (staleProperty == null) {
                return null;
            }
            StaleProperty property = staleProperty;
            int disablingDuration = property.getDisablingDuration();
            Integer deletionDuration = property.getDeletingDuration();
            List<String> promotionsToKeep = property.getPromotionsToKeep();
            if (disablingDuration <= 0) {
                this.logger.debug("[{}] No disabling time being set - exiting.", (Object)branch.getEntityDisplayName());
                return null;
            }
            LocalDateTime now = Time.now();
            LocalDateTime localDateTime = now.minusDays(disablingDuration);
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"now.minusDays(disablingDuration.toLong())");
            disablingTime = localDateTime;
            deletionTime = deletionDuration != null && deletionDuration > 0 ? disablingTime.minusDays(deletionDuration.intValue()) : null;
            this.logger.debug("[{}] Disabling time: {}", (Object)branch.getEntityDisplayName(), (Object)disablingTime);
            this.logger.debug("[{}] Deletion time: {}", (Object)branch.getEntityDisplayName(), (Object)deletionTime);
            Set promotionsToProtect = promotionsToKeep != null ? (Set)new HashSet(promotionsToKeep) : SetsKt.emptySet();
            List list = this.structureService.getBranchStatusView(branch).getPromotions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"structureService.getBran\u2026usView(branch).promotions");
            List lastPromotions = list;
            Iterable $this$any$iv = lastPromotions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PromotionView promotionView = (PromotionView)element$iv;
                    boolean bl2 = false;
                    if (!(promotionView.getPromotionRun() != null && promotionsToProtect.contains(promotionView.getPromotionLevel().getName()))) continue;
                    bl = true;
                    break block7;
                }
                bl = isProtected = false;
            }
        }
        if (isProtected) {
            this.logger.debug("[{}] Branch is promoted and is not eligible for staleness", (Object)branch.getEntityDisplayName());
            return StaleBranchStatus.KEEP;
        }
        Object object = lastBuild;
        if (object == null || (object = object.getSignature()) == null || (object = object.getTime()) == null) {
            object = lastTime = branch.getSignature().getTime();
        }
        return deletionTime != null && deletionTime.compareTo((ChronoLocalDateTime)lastTime) > 0 ? StaleBranchStatus.DELETE : (disablingTime.compareTo((ChronoLocalDateTime)lastTime) > 0 && !branch.isDisabled() ? StaleBranchStatus.DISABLE : null);
    }

    public PropertyBasedStaleBranchCheck(@NotNull StaleExtensionFeature extensionFeature, @NotNull PropertyService propertyService, @NotNull StructureService structureService) {
        Intrinsics.checkNotNullParameter((Object)((Object)extensionFeature), (String)"extensionFeature");
        Intrinsics.checkNotNullParameter((Object)propertyService, (String)"propertyService");
        Intrinsics.checkNotNullParameter((Object)structureService, (String)"structureService");
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
        this.structureService = structureService;
        Logger logger = LoggerFactory.getLogger(PropertyBasedStaleBranchCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(\u2026eBranchCheck::class.java)");
        this.logger = logger;
    }
}

