/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.MultiStrings;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StalePropertyType
extends AbstractPropertyType<StaleProperty> {
    public static final JobType STALE_BRANCH_JOB = JobCategory.of((String)"cleanup").withName("Cleanup").getType("stale-branches").withName("Stale branches cleanup");

    @Autowired
    public StalePropertyType(StaleExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Stale branches";
    }

    public String getDescription() {
        return "Allows to disable or delete stale branches";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, StaleProperty value) {
        return Form.create().with((Field)((Int)((Int)Int.of((String)"disablingDuration").label("Disabling branches after N (days)")).min(0).help("Number of days of inactivity after a branch is disabled. 0 means that the branch won't ever be disabled automatically.")).value((Object)(value != null ? value.getDisablingDuration() : 0))).with((Field)((Int)((Int)Int.of((String)"deletingDuration").label("Deleting branches after N (days) more")).min(0).help("Number of days of inactivity after a branch is deleted, after it has beendisabled automatically. 0 means that the branch won't ever be deleted automatically.")).value((Object)(value != null ? value.getDeletingDuration() : 0))).with((Field)((MultiStrings)((MultiStrings)MultiStrings.of((String)"promotionsToKeep").label("Promotions to keep")).help("List of promotion levels which prevent a branch to be disabled or deleted")).value(value != null ? value.getPromotionsToKeep() : Collections.emptyList()));
    }

    public StaleProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public StaleProperty fromStorage(JsonNode node) {
        return (StaleProperty)StalePropertyType.parse((JsonNode)node, StaleProperty.class);
    }

    public StaleProperty replaceValue(StaleProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

