/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.stale.StaleExtensionFeature;
import net.nemerosa.ontrack.extension.stale.StaleProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.job.Job;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobRegistration;
import net.nemerosa.ontrack.job.JobRun;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.job.JobScheduler;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventQueryService;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.support.JobProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StalePropertyType
extends AbstractPropertyType<StaleProperty>
implements JobProvider {
    public static final JobType STALE_BRANCH_JOB = JobCategory.of((String)"cleanup").withName("Cleanup").getType("stale-branches").withName("Stale branches cleanup");
    private final Logger logger = LoggerFactory.getLogger(StalePropertyType.class);
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final EventQueryService eventQueryService;
    private final JobScheduler jobScheduler;

    @Autowired
    public StalePropertyType(StaleExtensionFeature extensionFeature, StructureService structureService, PropertyService propertyService, EventQueryService eventQueryService, JobScheduler jobScheduler) {
        super((ExtensionFeature)extensionFeature);
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.eventQueryService = eventQueryService;
        this.jobScheduler = jobScheduler;
    }

    public String getName() {
        return "Stale branches";
    }

    public String getDescription() {
        return "Allows to disable or delete stale branches";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, StaleProperty value) {
        return Form.create().with((Field)((Int)((Int)Int.of((String)"disablingDuration").label("Disabling branches after N (days)")).min(0).help("Number of days of inactivity after a branch is disabled. 0 means that the branch won't ever be disabled automatically.")).value((Object)(value != null ? value.getDisablingDuration() : 0))).with((Field)((Int)((Int)Int.of((String)"deletingDuration").label("Deleting branches after N (days) more")).min(0).help("Number of days of inactivity after a branch is deleted, after it has beendisabled automatically. 0 means that the branch won't ever be deleted automatically.")).value((Object)(value != null ? value.getDeletingDuration() : 0)));
    }

    public StaleProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public StaleProperty fromStorage(JsonNode node) {
        return (StaleProperty)StalePropertyType.parse((JsonNode)node, StaleProperty.class);
    }

    public String getSearchKey(StaleProperty value) {
        return null;
    }

    public StaleProperty replaceValue(StaleProperty value, Function<String, String> replacementFunction) {
        return value;
    }

    public void onPropertyChanged(ProjectEntity entity, StaleProperty value) {
        if (this.propertyService.hasProperty((ProjectEntity)entity.getProject(), StalePropertyType.class)) {
            JobRegistration job = this.createStaleJob(entity.getProject());
            this.jobScheduler.schedule(job.getJob(), job.getSchedule());
        }
    }

    public void onPropertyDeleted(ProjectEntity entity, StaleProperty oldValue) {
        this.unscheduleStaleBranchJob((Project)entity);
    }

    public Collection<JobRegistration> getStartingJobs() {
        return this.structureService.getProjectList().stream().filter(project -> this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class)).map(this::createStaleJob).collect(Collectors.toList());
    }

    protected void unscheduleStaleBranchJob(Project project) {
        this.jobScheduler.unschedule(this.getStaleJobKey(project));
    }

    protected JobRegistration createStaleJob(final Project project) {
        return JobRegistration.of((Job)new Job(){

            public JobKey getKey() {
                return StalePropertyType.this.getStaleJobKey(project);
            }

            public JobRun getTask() {
                return runListener -> StalePropertyType.this.detectAndManageStaleBranches(runListener, project);
            }

            public String getDescription() {
                return "Detection and management of stale branches for " + project.getName();
            }

            public boolean isDisabled() {
                return project.isDisabled();
            }

            public boolean isValid() {
                return StalePropertyType.this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class);
            }
        }).withSchedule(Schedule.EVERY_DAY);
    }

    protected JobKey getStaleJobKey(Project project) {
        return STALE_BRANCH_JOB.getKey(String.valueOf(project.getId()));
    }

    protected void trace(Project project, String pattern, Object ... arguments) {
        this.logger.debug(String.format("[%s] %s", project.getName(), String.format(pattern, arguments)));
    }

    protected void detectAndManageStaleBranches(JobRunListener runListener, Project project) {
        this.propertyService.getProperty((ProjectEntity)project, StalePropertyType.class).option().ifPresent(property -> {
            int disablingDuration = property.getDisablingDuration();
            int deletionDuration = property.getDeletingDuration();
            if (disablingDuration <= 0) {
                this.trace(project, "No disabling time being set - exiting.", new Object[0]);
            } else {
                LocalDateTime now = Time.now();
                LocalDateTime disablingTime = now.minusDays(disablingDuration);
                Optional<Object> deletionTime = Optional.ofNullable(deletionDuration > 0 ? disablingTime.minusDays(deletionDuration) : null);
                this.trace(project, "Disabling time: %s", disablingTime);
                this.trace(project, "Deletion time: %s", deletionTime);
                runListener.message("Scanning %s project for stale branches", new Object[]{project.getName()});
                this.trace(project, "Scanning project for stale branches", new Object[0]);
                this.structureService.getBranchesForProject(project.getId()).forEach(branch -> this.detectAndManageStaleBranch((Branch)branch, disablingTime, deletionTime.orElse(null)));
            }
        });
    }

    protected void detectAndManageStaleBranch(Branch branch, LocalDateTime disablingTime, LocalDateTime deletionTime) {
        LocalDateTime lastTime;
        this.trace(branch.getProject(), "[%s] Scanning branch for staleness", branch.getName());
        if (branch.getType() == BranchType.TEMPLATE_DEFINITION) {
            this.trace(branch.getProject(), "[%s] Branch templates are not eligible for staleness", branch.getName());
            return;
        }
        Optional oBuild = this.structureService.getLastBuild(branch.getId());
        if (!oBuild.isPresent()) {
            this.trace(branch.getProject(), "[%s] No available build - taking branch's creation time", branch.getName());
            List events = this.eventQueryService.getEvents(ProjectEntityType.BRANCH, branch.getId(), EventFactory.NEW_BRANCH, 0, 1);
            if (events.isEmpty()) {
                this.trace(branch.getProject(), "[%s] No available branch creation date - keeping the branch", branch.getName());
                lastTime = Time.now();
            } else {
                lastTime = ((Event)events.get(0)).getSignature().getTime();
            }
        } else {
            Build build = (Build)oBuild.get();
            lastTime = build.getSignature().getTime();
        }
        this.trace(branch.getProject(), "[%s] Branch last build activity: %s", branch.getName(), lastTime);
        if (deletionTime != null && deletionTime.compareTo(lastTime) > 0) {
            this.trace(branch.getProject(), "[%s] Branch due for deletion", branch.getName());
            this.structureService.deleteBranch(branch.getId());
        } else if (disablingTime.compareTo(lastTime) > 0 && !branch.isDisabled()) {
            this.trace(branch.getProject(), "[%s] Branch due for staleness - disabling", branch.getName());
            this.structureService.saveBranch(branch.withDisabled(true));
        } else {
            this.trace(branch.getProject(), "[%s] Not touching the branch", branch.getName());
        }
    }
}

