/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.stale;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.stale.StaleJobService;
import net.nemerosa.ontrack.extension.stale.StalePropertyType;
import net.nemerosa.ontrack.job.Job;
import net.nemerosa.ontrack.job.JobCategory;
import net.nemerosa.ontrack.job.JobKey;
import net.nemerosa.ontrack.job.JobRegistration;
import net.nemerosa.ontrack.job.JobRun;
import net.nemerosa.ontrack.job.JobRunListener;
import net.nemerosa.ontrack.job.JobType;
import net.nemerosa.ontrack.job.Schedule;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventQueryService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StaleJobServiceImpl
implements StaleJobService {
    private final Logger logger = LoggerFactory.getLogger(StaleJobServiceImpl.class);
    public static final JobType STALE_BRANCH_JOB = JobCategory.of((String)"cleanup").withName("Cleanup").getType("stale-branches").withName("Stale branches cleanup");
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final EventQueryService eventQueryService;

    @Autowired
    public StaleJobServiceImpl(StructureService structureService, PropertyService propertyService, EventQueryService eventQueryService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.eventQueryService = eventQueryService;
    }

    public Stream<JobRegistration> collectJobRegistrations() {
        return this.structureService.getProjectList().stream().filter(project -> this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class)).map(this::createStaleJob);
    }

    protected JobRegistration createStaleJob(final Project project) {
        return JobRegistration.of((Job)new Job(){

            public JobKey getKey() {
                return StaleJobServiceImpl.this.getStaleJobKey(project);
            }

            public JobRun getTask() {
                return runListener -> StaleJobServiceImpl.this.detectAndManageStaleBranches(runListener, project);
            }

            public String getDescription() {
                return "Detection and management of stale branches for " + project.getName();
            }

            public boolean isDisabled() {
                return project.isDisabled();
            }

            public boolean isValid() {
                return StaleJobServiceImpl.this.propertyService.hasProperty((ProjectEntity)project, StalePropertyType.class);
            }
        }).withSchedule(Schedule.EVERY_DAY);
    }

    protected JobKey getStaleJobKey(Project project) {
        return STALE_BRANCH_JOB.getKey(String.valueOf(project.getId()));
    }

    protected void trace(Project project, String pattern, Object ... arguments) {
        this.logger.debug(String.format("[%s] %s", project.getName(), String.format(pattern, arguments)));
    }

    @Override
    public void detectAndManageStaleBranches(JobRunListener runListener, Project project) {
        this.propertyService.getProperty((ProjectEntity)project, StalePropertyType.class).option().ifPresent(property -> {
            int disablingDuration = property.getDisablingDuration();
            int deletionDuration = property.getDeletingDuration();
            List<String> promotionsToKeep = property.getPromotionsToKeep();
            if (disablingDuration <= 0) {
                this.trace(project, "No disabling time being set - exiting.", new Object[0]);
            } else {
                LocalDateTime now = Time.now();
                LocalDateTime disablingTime = now.minusDays(disablingDuration);
                Optional<Object> deletionTime = Optional.ofNullable(deletionDuration > 0 ? disablingTime.minusDays(deletionDuration) : null);
                this.trace(project, "Disabling time: %s", disablingTime);
                this.trace(project, "Deletion time: %s", deletionTime);
                runListener.message("Scanning %s project for stale branches", new Object[]{project.getName()});
                this.trace(project, "Scanning project for stale branches", new Object[0]);
                this.structureService.getBranchesForProject(project.getId()).forEach(branch -> this.detectAndManageStaleBranch((Branch)branch, disablingTime, deletionTime.orElse(null), promotionsToKeep));
            }
        });
    }

    @Override
    public void detectAndManageStaleBranch(Branch branch, LocalDateTime disablingTime, LocalDateTime deletionTime, List<String> promotionsToKeep) {
        LocalDateTime lastTime;
        this.trace(branch.getProject(), "[%s] Scanning branch for staleness", branch.getName());
        if (branch.getType() == BranchType.TEMPLATE_DEFINITION) {
            this.trace(branch.getProject(), "[%s] Branch templates are not eligible for staleness", branch.getName());
            return;
        }
        Set<Object> promotionsToProtect = promotionsToKeep != null ? new HashSet<String>(promotionsToKeep) : Collections.emptySet();
        List lastPromotions = this.structureService.getBranchStatusView(branch).getPromotions();
        boolean isProtected = lastPromotions.stream().anyMatch(promotionView -> promotionView.getPromotionRun() != null && promotionsToProtect.contains(promotionView.getPromotionLevel().getName()));
        if (isProtected) {
            this.trace(branch.getProject(), "[%s] Branch is promoted and is not eligible for staleness", branch.getName());
            return;
        }
        Optional oBuild = this.structureService.getLastBuild(branch.getId());
        if (!oBuild.isPresent()) {
            this.trace(branch.getProject(), "[%s] No available build - taking branch's creation time", branch.getName());
            List events = this.eventQueryService.getEvents(ProjectEntityType.BRANCH, branch.getId(), EventFactory.NEW_BRANCH, 0, 1);
            if (events.isEmpty()) {
                this.trace(branch.getProject(), "[%s] No available branch creation date - keeping the branch", branch.getName());
                lastTime = Time.now();
            } else {
                lastTime = ((Event)events.get(0)).getSignature().getTime();
            }
        } else {
            Build build = (Build)oBuild.get();
            lastTime = build.getSignature().getTime();
        }
        this.trace(branch.getProject(), "[%s] Branch last build activity: %s", branch.getName(), lastTime);
        if (deletionTime != null && deletionTime.compareTo(lastTime) > 0) {
            this.trace(branch.getProject(), "[%s] Branch due for deletion", branch.getName());
            this.structureService.deleteBranch(branch.getId());
        } else if (disablingTime.compareTo(lastTime) > 0 && !branch.isDisabled()) {
            this.trace(branch.getProject(), "[%s] Branch due for staleness - disabling", branch.getName());
            this.structureService.saveBranch(branch.withDisabled(true));
        } else {
            this.trace(branch.getProject(), "[%s] Not touching the branch", branch.getName());
        }
    }
}

