/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.service;

import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLog;
import net.nemerosa.ontrack.extension.scm.model.SCMChangeLogIssue;
import net.nemerosa.ontrack.extension.scm.property.SCMChangeLogIssueValidator;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.StructureService;

public abstract class AbstractSCMChangeLogService<S, T, I extends SCMChangeLogIssue> {
    protected final StructureService structureService;
    protected final PropertyService propertyService;

    protected AbstractSCMChangeLogService(StructureService structureService, PropertyService propertyService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
    }

    protected BuildView getBuildView(ID id) {
        return this.structureService.getBuildView(this.structureService.getBuild(id), true);
    }

    protected void validateIssues(List<I> issuesList, SCMChangeLog<T> changeLog) {
        if (changeLog.isSameBranch()) {
            Branch branch = changeLog.getFrom().getBuild().getBranch();
            List properties = this.propertyService.getProperties((ProjectEntity)branch).stream().filter(property -> !property.isEmpty() && property.getType() instanceof SCMChangeLogIssueValidator).collect(Collectors.toList());
            issuesList.forEach(issue -> this.validateIssue(issue, properties, changeLog));
        }
    }

    protected void validateIssue(I issue, List<Property<?>> properties, SCMChangeLog<T> changeLog) {
        for (Property<?> property : properties) {
            if (property.isEmpty()) continue;
            this.validateIssue(issue, property, changeLog);
        }
    }

    private <C> void validateIssue(I issue, Property<C> property, SCMChangeLog<T> changeLog) {
        SCMChangeLogIssueValidator validator = (SCMChangeLogIssueValidator)property.getType();
        validator.validate(changeLog, issue, property.getValue());
    }
}

