/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.model;

import com.google.common.collect.Lists;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.scm.model.SCMFileChangeFilter;

public class SCMFileChangeFilters {
    private final List<SCMFileChangeFilter> filters;

    public static SCMFileChangeFilters create() {
        return new SCMFileChangeFilters(Collections.emptyList());
    }

    public SCMFileChangeFilters save(SCMFileChangeFilter filter) {
        return this.with(store -> store.put(filter.getName(), filter));
    }

    public SCMFileChangeFilters remove(String name) {
        return this.with(store -> {
            SCMFileChangeFilter cfr_ignored_0 = (SCMFileChangeFilter)store.remove(name);
        });
    }

    protected SCMFileChangeFilters with(Consumer<Map<String, SCMFileChangeFilter>> action) {
        TreeMap<String, SCMFileChangeFilter> store = new TreeMap<String, SCMFileChangeFilter>(this.filters.stream().collect(Collectors.toMap(SCMFileChangeFilter::getName, f -> f)));
        action.accept(store);
        return new SCMFileChangeFilters(Lists.newArrayList(store.values()));
    }

    @ConstructorProperties(value={"filters"})
    public SCMFileChangeFilters(List<SCMFileChangeFilter> filters) {
        this.filters = filters;
    }

    public List<SCMFileChangeFilter> getFilters() {
        return this.filters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCMFileChangeFilters)) {
            return false;
        }
        SCMFileChangeFilters other = (SCMFileChangeFilters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SCMFileChangeFilter> this$filters = this.getFilters();
        List<SCMFileChangeFilter> other$filters = other.getFilters();
        return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCMFileChangeFilters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SCMFileChangeFilter> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        return result;
    }

    public String toString() {
        return "SCMFileChangeFilters(filters=" + this.getFilters() + ")";
    }
}

