/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import net.nemerosa.ontrack.extension.scm.model.SCMBuildView;
import net.nemerosa.ontrack.model.buildfilter.BuildDiff;
import net.nemerosa.ontrack.model.structure.BuildView;
import net.nemerosa.ontrack.model.structure.Project;

public class SCMChangeLog<T>
extends BuildDiff {
    private final String uuid;
    private final SCMBuildView<T> scmBuildFrom;
    private final SCMBuildView<T> scmBuildTo;

    protected SCMChangeLog(String uuid, Project project, SCMBuildView<T> scmBuildFrom, SCMBuildView<T> scmBuildTo) {
        super(project);
        this.uuid = uuid;
        this.scmBuildFrom = scmBuildFrom;
        this.scmBuildTo = scmBuildTo;
    }

    @JsonIgnore
    public BuildView getFrom() {
        return this.scmBuildFrom.getBuildView();
    }

    @JsonIgnore
    public BuildView getTo() {
        return this.scmBuildTo.getBuildView();
    }

    @JsonIgnore
    public boolean isSameBranch() {
        return this.getFrom().getBuild().getBranch().id() == this.getTo().getBuild().getBranch().id();
    }

    public static <T> SCMChangeLog<T> of(Project project, SCMBuildView<T> from, SCMBuildView<T> to) {
        return new SCMChangeLog<T>(UUID.randomUUID().toString(), project, from, to);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCMChangeLog)) {
            return false;
        }
        SCMChangeLog other = (SCMChangeLog)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        SCMBuildView<T> this$scmBuildFrom = this.getScmBuildFrom();
        SCMBuildView<T> other$scmBuildFrom = other.getScmBuildFrom();
        if (this$scmBuildFrom == null ? other$scmBuildFrom != null : !((Object)this$scmBuildFrom).equals(other$scmBuildFrom)) {
            return false;
        }
        SCMBuildView<T> this$scmBuildTo = this.getScmBuildTo();
        SCMBuildView<T> other$scmBuildTo = other.getScmBuildTo();
        return !(this$scmBuildTo == null ? other$scmBuildTo != null : !((Object)this$scmBuildTo).equals(other$scmBuildTo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCMChangeLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        SCMBuildView<T> $scmBuildFrom = this.getScmBuildFrom();
        result = result * 59 + ($scmBuildFrom == null ? 43 : ((Object)$scmBuildFrom).hashCode());
        SCMBuildView<T> $scmBuildTo = this.getScmBuildTo();
        result = result * 59 + ($scmBuildTo == null ? 43 : ((Object)$scmBuildTo).hashCode());
        return result;
    }

    public String getUuid() {
        return this.uuid;
    }

    public SCMBuildView<T> getScmBuildFrom() {
        return this.scmBuildFrom;
    }

    public SCMBuildView<T> getScmBuildTo() {
        return this.scmBuildTo;
    }

    public String toString() {
        return "SCMChangeLog(uuid=" + this.getUuid() + ", scmBuildFrom=" + this.getScmBuildFrom() + ", scmBuildTo=" + this.getScmBuildTo() + ")";
    }
}

