/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.scm.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Memo;
import org.apache.commons.lang3.StringUtils;

public class SCMBranchesTemplateSynchronisationSourceConfig {
    private final String includes;
    private final String excludes;

    @JsonIgnore
    public Predicate<String> getFilter() {
        Set<String> include = SCMBranchesTemplateSynchronisationSourceConfig.parse(this.includes);
        Set<String> exclude = SCMBranchesTemplateSynchronisationSourceConfig.parse(this.excludes);
        return name -> SCMBranchesTemplateSynchronisationSourceConfig.matches(include, name, true) && !SCMBranchesTemplateSynchronisationSourceConfig.matches(exclude, name, false);
    }

    protected static Set<String> parse(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return Collections.emptySet();
        }
        return Arrays.asList(StringUtils.split((String)text, (String)"\n\r")).stream().map(String::trim).filter(s -> s.length() != 0 && !s.startsWith("#")).collect(Collectors.toSet());
    }

    protected static boolean matches(Set<String> patterns, String name, boolean emptyMeansAll) {
        if (patterns.isEmpty()) {
            return emptyMeansAll;
        }
        return patterns.stream().filter(pattern -> SCMBranchesTemplateSynchronisationSourceConfig.matches(pattern, name)).findFirst().isPresent();
    }

    private static boolean matches(String pattern, String name) {
        if ("*".equals(pattern)) {
            return true;
        }
        if (pattern.contains("*")) {
            return Pattern.matches(pattern.replaceAll("\\*", ".*"), name);
        }
        return StringUtils.equals((CharSequence)pattern, (CharSequence)name);
    }

    public static Form form() {
        return Form.create().with((Field)((Memo)((Memo)Memo.of((String)"includes").label("Includes")).optional()).help("@file:extension/scm/help.net.nemerosa.ontrack.extension.scm.model.SCMBranchesTemplateSynchronisationSourceConfig.includes.tpl.html")).with((Field)((Memo)((Memo)Memo.of((String)"excludes").label("Excludes")).optional()).help("@file:extension/scm/help.net.nemerosa.ontrack.extension.scm.model.SCMBranchesTemplateSynchronisationSourceConfig.excludes.tpl.html"));
    }

    @ConstructorProperties(value={"includes", "excludes"})
    public SCMBranchesTemplateSynchronisationSourceConfig(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCMBranchesTemplateSynchronisationSourceConfig)) {
            return false;
        }
        SCMBranchesTemplateSynchronisationSourceConfig other = (SCMBranchesTemplateSynchronisationSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$includes = this.getIncludes();
        String other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !this$includes.equals(other$includes)) {
            return false;
        }
        String this$excludes = this.getExcludes();
        String other$excludes = other.getExcludes();
        return !(this$excludes == null ? other$excludes != null : !this$excludes.equals(other$excludes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SCMBranchesTemplateSynchronisationSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : $includes.hashCode());
        String $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : $excludes.hashCode());
        return result;
    }

    public String toString() {
        return "SCMBranchesTemplateSynchronisationSourceConfig(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }
}

