/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.metrics.influxdb.client;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbPoint;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbSender;
import net.nemerosa.ontrack.model.metrics.OntrackTaggedMetrics;
import net.nemerosa.ontrack.model.metrics.TaggedMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDbReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDbReporter.class);
    private final InfluxDbSender influxDb;
    private final boolean skipIdleMetrics;
    private final Map<String, Long> previousValues;
    private final Collection<OntrackTaggedMetrics> taggedMetrics;

    private InfluxDbReporter(MetricRegistry registry, InfluxDbSender influxDb, Map<String, String> tags, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, boolean skipIdleMetrics, Collection<OntrackTaggedMetrics> taggedMetrics) {
        super(registry, "influxDb-reporter", filter, rateUnit, durationUnit);
        this.influxDb = influxDb;
        this.taggedMetrics = taggedMetrics;
        influxDb.setTags(tags);
        this.skipIdleMetrics = skipIdleMetrics;
        this.previousValues = new TreeMap<String, Long>();
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long now = System.currentTimeMillis();
        try {
            this.influxDb.flush();
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), now);
            }
            for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), (Counter)entry.getValue(), now);
            }
            for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), now);
            }
            for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
                this.reportMeter(entry.getKey(), (Metered)entry.getValue(), now);
            }
            for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), now);
            }
            this.taggedMetrics.stream().flatMap(source -> source.getTaggedMetrics().stream()).forEach(this::reportTaggedMetric);
            if (this.influxDb.hasSeriesData()) {
                this.influxDb.writeData();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to report to InfluxDB. Discarding data.", (Throwable)e);
        }
    }

    private <T extends Number> void reportTaggedMetric(TaggedMetric<T> metric) {
        this.influxDb.appendPoints(new InfluxDbPoint(metric.getName(), metric.getTags(), metric.getTimestamp().getTime(), Collections.singletonMap("value", metric.getValue())));
    }

    private void reportTimer(String name, Timer timer, long now) {
        if (this.canSkipMetric(name, (Counting)timer)) {
            return;
        }
        Snapshot snapshot = timer.getSnapshot();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", timer.getCount());
        fields.put("min", this.convertDuration(snapshot.getMin()));
        fields.put("max", this.convertDuration(snapshot.getMax()));
        fields.put("mean", this.convertDuration(snapshot.getMean()));
        fields.put("std-dev", this.convertDuration(snapshot.getStdDev()));
        fields.put("median", this.convertDuration(snapshot.getMedian()));
        fields.put("50-percentile", this.convertDuration(snapshot.getMedian()));
        fields.put("75-percentile", this.convertDuration(snapshot.get75thPercentile()));
        fields.put("95-percentile", this.convertDuration(snapshot.get95thPercentile()));
        fields.put("98-percentile", this.convertDuration(snapshot.get98thPercentile()));
        fields.put("99-percentile", this.convertDuration(snapshot.get99thPercentile()));
        fields.put("999-percentile", this.convertDuration(snapshot.get999thPercentile()));
        fields.put("one-minute", this.convertRate(timer.getOneMinuteRate()));
        fields.put("five-minute", this.convertRate(timer.getFiveMinuteRate()));
        fields.put("fifteen-minute", this.convertRate(timer.getFifteenMinuteRate()));
        fields.put("mean-rate", this.convertRate(timer.getMeanRate()));
        fields.put("run-count", timer.getCount());
        this.influxDb.appendPoints(new InfluxDbPoint(name, Collections.emptyMap(), now, fields));
    }

    private void reportHistogram(String name, Histogram histogram, long now) {
        if (this.canSkipMetric(name, (Counting)histogram)) {
            return;
        }
        Snapshot snapshot = histogram.getSnapshot();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", histogram.getCount());
        fields.put("min", snapshot.getMin());
        fields.put("max", snapshot.getMax());
        fields.put("mean", snapshot.getMean());
        fields.put("median", snapshot.getMedian());
        fields.put("std-dev", snapshot.getStdDev());
        fields.put("50-percentile", snapshot.getMedian());
        fields.put("75-percentile", snapshot.get75thPercentile());
        fields.put("95-percentile", snapshot.get95thPercentile());
        fields.put("98-percentile", snapshot.get98thPercentile());
        fields.put("99-percentile", snapshot.get99thPercentile());
        fields.put("999-percentile", snapshot.get999thPercentile());
        fields.put("run-count", histogram.getCount());
        this.influxDb.appendPoints(new InfluxDbPoint(name, Collections.emptyMap(), now, fields));
    }

    private void reportCounter(String name, Counter counter, long now) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", counter.getCount());
        this.influxDb.appendPoints(new InfluxDbPoint(name, Collections.emptyMap(), now, fields));
    }

    private void reportGauge(String name, Gauge<?> gauge, long now) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("value", gauge.getValue());
        this.influxDb.appendPoints(new InfluxDbPoint(name, Collections.emptyMap(), now, fields));
    }

    private void reportMeter(String name, Metered meter, long now) {
        if (this.canSkipMetric(name, (Counting)meter)) {
            return;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", meter.getCount());
        fields.put("one-minute", this.convertRate(meter.getOneMinuteRate()));
        fields.put("five-minute", this.convertRate(meter.getFiveMinuteRate()));
        fields.put("fifteen-minute", this.convertRate(meter.getFifteenMinuteRate()));
        fields.put("mean-rate", this.convertRate(meter.getMeanRate()));
        this.influxDb.appendPoints(new InfluxDbPoint(name, Collections.emptyMap(), now, fields));
    }

    private boolean canSkipMetric(String name, Counting counting) {
        boolean isIdle;
        boolean bl = isIdle = this.calculateDelta(name, counting.getCount()) == 0L;
        if (this.skipIdleMetrics && !isIdle) {
            this.previousValues.put(name, counting.getCount());
        }
        return this.skipIdleMetrics && isIdle;
    }

    private long calculateDelta(String name, long count) {
        Long previous = this.previousValues.get(name);
        if (previous == null) {
            return -1L;
        }
        if (count < previous) {
            LOGGER.warn("Saw a non-monotonically increasing value for metric '{}'", (Object)name);
            return 0L;
        }
        return count - previous;
    }

    public static final class Builder {
        private final MetricRegistry registry;
        private Map<String, String> tags;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private boolean skipIdleMetrics;
        private Collection<OntrackTaggedMetrics> taggedMetrics = Collections.emptyList();

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.tags = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withTaggedMetrics(Collection<OntrackTaggedMetrics> taggedMetrics) {
            this.taggedMetrics = Collections.unmodifiableCollection(taggedMetrics);
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = Collections.unmodifiableMap(tags);
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.skipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public InfluxDbReporter build(InfluxDbSender influxDb) {
            return new InfluxDbReporter(this.registry, influxDb, this.tags, this.rateUnit, this.durationUnit, this.filter, this.skipIdleMetrics, this.taggedMetrics);
        }
    }
}

