/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.metrics.influxdb.client;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbPoint;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbSender;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;

public class InfluxDbHttpSender
implements InfluxDbSender {
    private final InfluxDB influxDB;
    private final BatchPoints batchPoints;
    private final TimeUnit timePrecision;

    public InfluxDbHttpSender(String hostname, int port, String database, String username, String password, String retentionPolicy, TimeUnit timePrecision) throws Exception {
        this.timePrecision = timePrecision;
        this.influxDB = InfluxDBFactory.connect((String)String.format("http://%s:%d", hostname, port), (String)username, (String)password);
        this.influxDB.createDatabase(database);
        this.batchPoints = BatchPoints.database((String)database).tag("async", "true").retentionPolicy(retentionPolicy).consistency(InfluxDB.ConsistencyLevel.ALL).build();
    }

    @Override
    public synchronized void flush() {
        this.influxDB.write(this.batchPoints);
        this.batchPoints.getPoints().clear();
    }

    @Override
    public boolean hasSeriesData() {
        return this.batchPoints.getPoints() != null && !this.batchPoints.getPoints().isEmpty();
    }

    @Override
    public void appendPoints(InfluxDbPoint point) {
        if (point != null) {
            this.batchPoints.point(Point.measurement((String)point.getMeasurement()).fields(point.getFields()).time(point.getTimestamp(), this.timePrecision).tag(point.getTags()).build());
        }
    }

    @Override
    public void setTags(Map<String, String> tags) {
    }

    @Override
    public void writeData() throws Exception {
        this.flush();
    }
}

