/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.metrics.influxdb;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import net.nemerosa.ontrack.extension.metrics.influxdb.InfluxdbMetricsConfigProperties;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbHttpSender;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbReporter;
import net.nemerosa.ontrack.extension.metrics.influxdb.client.InfluxDbSender;
import net.nemerosa.ontrack.model.metrics.OntrackTaggedMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ontrack.metrics.influxdb.host"})
public class InfluxdbMetricsConfig {
    private final Logger logger = LoggerFactory.getLogger(InfluxdbMetricsConfig.class);
    private final InfluxdbMetricsConfigProperties config;
    private final MetricRegistry registry;
    private final Collection<OntrackTaggedMetrics> taggedMetrics;

    @Autowired
    public InfluxdbMetricsConfig(InfluxdbMetricsConfigProperties config, MetricRegistry registry, Collection<OntrackTaggedMetrics> taggedMetrics) {
        this.config = config;
        this.registry = registry;
        this.taggedMetrics = taggedMetrics;
    }

    @Bean
    public InfluxDbSender influxdb() throws Exception {
        return new InfluxDbHttpSender(this.config.getHost(), this.config.getPort(), this.config.getDatabase(), this.config.getUser(), this.config.getPassword(), this.config.getRetentionPolicy(), TimeUnit.MILLISECONDS);
    }

    @Bean
    public InfluxDbReporter influxdbReporter() throws Exception {
        InfluxDbReporter reporter = InfluxDbReporter.forRegistry(this.registry).withTags(Collections.singletonMap("src", "ontrack")).withTaggedMetrics(this.taggedMetrics).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).skipIdleMetrics(true).build(this.influxdb());
        this.logger.info("[metrics] Starting InfluxDB reporting to {}@{}:{}/{}", new Object[]{this.config.getUser(), this.config.getHost(), this.config.getPort(), this.config.getDatabase()});
        reporter.start(this.config.getPeriod(), TimeUnit.SECONDS);
        return reporter;
    }
}

