/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.metrics.graphite;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.util.concurrent.TimeUnit;
import net.nemerosa.ontrack.extension.metrics.graphite.GraphiteMetricsConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"ontrack.metrics.graphite.host"}, havingValue="")
public class GraphiteMetricsConfig {
    private final Logger logger = LoggerFactory.getLogger(GraphiteMetricsConfig.class);
    @Autowired
    private GraphiteMetricsConfigProperties config;
    @Autowired
    private MetricRegistry registry;

    @Bean
    public Graphite graphite() {
        return new Graphite(this.config.getHost(), this.config.getPort());
    }

    @Bean
    public GraphiteReporter graphiteReporter() {
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.registry).prefixedWith("ontrack").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(this.graphite());
        this.logger.info("[metrics] Starting Graphite reporting to {}:{}", (Object)this.config.getHost(), (Object)this.config.getPort());
        reporter.start((long)this.config.getPeriod(), TimeUnit.SECONDS);
        return reporter;
    }
}

