/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira.tx;

import net.nemerosa.ontrack.client.JsonClient;
import net.nemerosa.ontrack.extension.jira.JIRAConfiguration;
import net.nemerosa.ontrack.extension.jira.client.JIRAClient;
import net.nemerosa.ontrack.extension.jira.client.JIRAClientImpl;
import net.nemerosa.ontrack.extension.jira.tx.JIRASession;
import net.nemerosa.ontrack.extension.jira.tx.JIRASessionFactory;
import net.nemerosa.ontrack.extension.support.client.ClientConnection;
import net.nemerosa.ontrack.extension.support.client.ClientFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JIRASessionFactoryImpl
implements JIRASessionFactory {
    private final ClientFactory clientFactory;

    @Autowired
    public JIRASessionFactoryImpl(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public JIRASession create(JIRAConfiguration configuration) {
        JsonClient jsonClient = this.clientFactory.getJsonClient(new ClientConnection(configuration.getUrl(), configuration.getUser(), configuration.getPassword()));
        final JIRAClientImpl client = new JIRAClientImpl(jsonClient);
        return new JIRASession(){

            @Override
            public JIRAClient getClient() {
                return client;
            }

            public void close() {
                client.close();
            }
        };
    }
}

