/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.nemerosa.ontrack.client.ClientForbiddenException;
import net.nemerosa.ontrack.client.ClientNotFoundException;
import net.nemerosa.ontrack.client.JsonClient;
import net.nemerosa.ontrack.extension.jira.JIRAConfiguration;
import net.nemerosa.ontrack.extension.jira.client.JIRAClient;
import net.nemerosa.ontrack.extension.jira.model.JIRAField;
import net.nemerosa.ontrack.extension.jira.model.JIRAIssue;
import net.nemerosa.ontrack.extension.jira.model.JIRALink;
import net.nemerosa.ontrack.extension.jira.model.JIRAStatus;
import net.nemerosa.ontrack.extension.jira.model.JIRAVersion;
import org.apache.commons.lang3.StringUtils;

public class JIRAClientImpl
implements JIRAClient {
    public static final DateTimeFormatter JIRA_DATA_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final JsonClient jsonClient;

    public JIRAClientImpl(JsonClient jsonClient) {
        this.jsonClient = jsonClient;
    }

    @Override
    public JIRAIssue getIssue(String key, JIRAConfiguration configuration) {
        JsonNode node;
        try {
            node = this.jsonClient.get("/rest/api/2/issue/%s?expand=names", new Object[]{key});
        }
        catch (ClientForbiddenException ex) {
            return null;
        }
        catch (ClientNotFoundException ex) {
            return null;
        }
        return JIRAClientImpl.toIssue(configuration, node);
    }

    @Override
    public List<String> getProjects() {
        JsonNode node = this.jsonClient.get("/rest/api/2/project", new Object[0]);
        ArrayList<String> projects = new ArrayList<String>();
        for (JsonNode child : node) {
            projects.add(child.path("key").asText());
        }
        return projects;
    }

    protected static JIRAIssue toIssue(JIRAConfiguration configuration, JsonNode node) {
        ArrayList<JIRAField> fields = new ArrayList<JIRAField>();
        JsonNode names = node.path("names");
        Iterator nameFields = names.fields();
        while (nameFields.hasNext()) {
            Map.Entry nameField = (Map.Entry)nameFields.next();
            String name = (String)nameField.getKey();
            String displayName = ((JsonNode)nameField.getValue()).asText();
            JsonNode fieldNode = JIRAClientImpl.field(node, name);
            fields.add(new JIRAField(name, displayName, fieldNode));
        }
        List<JIRAVersion> affectedVersions = JIRAClientImpl.toVersions(node, "versions");
        List<JIRAVersion> fixVersions = JIRAClientImpl.toVersions(node, "fixVersions");
        JIRAStatus status = JIRAClientImpl.getStatus(node);
        String key = node.path("key").asText();
        ArrayList<JIRALink> links = new ArrayList<JIRALink>();
        for (JsonNode issueLinkNode : JIRAClientImpl.field(node, "issuelinks")) {
            String inwardKey = issueLinkNode.path("inwardIssue").path("key").asText();
            String outwardKey = issueLinkNode.path("outwardIssue").path("key").asText();
            if (StringUtils.isNotBlank((CharSequence)inwardKey)) {
                links.add(new JIRALink(inwardKey, issueLinkNode.path("inwardIssue").path("self").asText(), JIRAClientImpl.getStatus(issueLinkNode.path("inwardIssue")), issueLinkNode.path("type").path("name").asText(), issueLinkNode.path("type").path("inward").asText()));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)outwardKey)) continue;
            links.add(new JIRALink(outwardKey, issueLinkNode.path("outwardIssue").path("self").asText(), JIRAClientImpl.getStatus(issueLinkNode.path("outwardIssue")), issueLinkNode.path("type").path("name").asText(), issueLinkNode.path("type").path("outward").asText()));
        }
        return new JIRAIssue(configuration.getIssueURL(key), key, JIRAClientImpl.fieldValue(node, "summary"), status, JIRAClientImpl.field(node, "assignee").path("name").asText(), JIRAClientImpl.parseFromJIRA(JIRAClientImpl.fieldValue(node, "updated")), fields, affectedVersions, fixVersions, JIRAClientImpl.field(node, "issuetype").path("name").asText(), links);
    }

    private static JIRAStatus getStatus(JsonNode node) {
        JsonNode statusNode = JIRAClientImpl.field(node, "status");
        return new JIRAStatus(statusNode.path("name").asText(), statusNode.path("iconUrl").asText());
    }

    public static LocalDateTime parseFromJIRA(String value) {
        return LocalDateTime.ofInstant(ZonedDateTime.parse(value, JIRA_DATA_TIME).toInstant(), ZoneOffset.UTC);
    }

    private static List<JIRAVersion> toVersions(JsonNode node, String versionFieldName) {
        JsonNode versionField = JIRAClientImpl.field(node, versionFieldName);
        ArrayList<JIRAVersion> versions = new ArrayList<JIRAVersion>();
        for (JsonNode versionNode : versionField) {
            versions.add(new JIRAVersion(versionNode.path("name").asText(), versionNode.path("released").asBoolean()));
        }
        return versions;
    }

    private static String fieldValue(JsonNode node, String name) {
        return JIRAClientImpl.field(node, name).asText();
    }

    private static JsonNode field(JsonNode node, String name) {
        return node.path("fields").path(name);
    }

    @Override
    public void close() {
    }
}

