/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira;

import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceFactory;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.support.AbstractIssueServiceExtension;
import net.nemerosa.ontrack.extension.jira.JIRAConfiguration;
import net.nemerosa.ontrack.extension.jira.JIRAConfigurationService;
import net.nemerosa.ontrack.extension.jira.JIRAExtensionFeature;
import net.nemerosa.ontrack.extension.jira.JIRAFollowLinksPropertyType;
import net.nemerosa.ontrack.extension.jira.client.JIRAClient;
import net.nemerosa.ontrack.extension.jira.model.JIRAIssue;
import net.nemerosa.ontrack.extension.jira.tx.JIRASession;
import net.nemerosa.ontrack.extension.jira.tx.JIRASessionFactory;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.support.MessageAnnotation;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import net.nemerosa.ontrack.model.support.RegexMessageAnnotator;
import net.nemerosa.ontrack.tx.Transaction;
import net.nemerosa.ontrack.tx.TransactionService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JIRAServiceExtension
extends AbstractIssueServiceExtension {
    public static final String SERVICE = "jira";
    private final JIRAConfigurationService jiraConfigurationService;
    private final JIRASessionFactory jiraSessionFactory;
    private final TransactionService transactionService;
    private final PropertyService propertyService;

    @Autowired
    public JIRAServiceExtension(JIRAExtensionFeature extensionFeature, JIRAConfigurationService jiraConfigurationService, JIRASessionFactory jiraSessionFactory, TransactionService transactionService, IssueExportServiceFactory issueExportServiceFactory, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature, SERVICE, "JIRA", issueExportServiceFactory);
        this.jiraConfigurationService = jiraConfigurationService;
        this.jiraSessionFactory = jiraSessionFactory;
        this.transactionService = transactionService;
        this.propertyService = propertyService;
    }

    public List<? extends IssueServiceConfiguration> getConfigurationList() {
        return this.jiraConfigurationService.getConfigurations();
    }

    public IssueServiceConfiguration getConfigurationByName(String name) {
        return this.jiraConfigurationService.getOptionalConfiguration(name).orElse(null);
    }

    public Optional<String> getIssueId(IssueServiceConfiguration issueServiceConfiguration, String token) {
        return this.validIssueToken(token) ? Optional.of(token) : Optional.empty();
    }

    public Collection<? extends Issue> getLinkedIssues(Project project, IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        return this.propertyService.getProperty((ProjectEntity)project, JIRAFollowLinksPropertyType.class).option().map(property -> {
            LinkedHashMap<String, JIRAIssue> issues = new LinkedHashMap<String, JIRAIssue>();
            this.followLinks((JIRAConfiguration)issueServiceConfiguration, (JIRAIssue)issue, Sets.newHashSet(property.getLinkNames()), issues);
            return issues.values();
        }).orElse(Collections.singleton((JIRAIssue)issue));
    }

    public boolean validIssueToken(String token) {
        return StringUtils.isNotBlank((CharSequence)token) && JIRAConfiguration.ISSUE_PATTERN.matcher(token).matches();
    }

    public Set<String> extractIssueKeysFromMessage(IssueServiceConfiguration issueServiceConfiguration, String message) {
        return this.extractJIRAIssuesFromMessage((JIRAConfiguration)issueServiceConfiguration, message);
    }

    public Optional<MessageAnnotator> getMessageAnnotator(IssueServiceConfiguration issueServiceConfiguration) {
        JIRAConfiguration configuration = (JIRAConfiguration)issueServiceConfiguration;
        return Optional.of(new RegexMessageAnnotator(JIRAConfiguration.ISSUE_PATTERN, key -> MessageAnnotation.of((String)"a").attr("href", configuration.getIssueURL((String)key)).text(key)));
    }

    public String getLinkForAllIssues(IssueServiceConfiguration issueServiceConfiguration, List<Issue> issues) {
        Validate.notNull((Object)issueServiceConfiguration, (String)"The issue service configuration is required", (Object[])new Object[0]);
        Validate.notNull(issues, (String)"The list of issues must not be null", (Object[])new Object[0]);
        JIRAConfiguration configuration = (JIRAConfiguration)issueServiceConfiguration;
        if (issues.size() == 0) {
            return "";
        }
        if (issues.size() == 1) {
            return String.format("%s/browse/%s", configuration.getUrl(), issues.iterator().next().getKey());
        }
        try {
            return String.format("%s/secure/IssueNavigator.jspa?reset=true&mode=hide&jqlQuery=%s", configuration.getUrl(), URLEncoder.encode(String.format("key in (%s)", StringUtils.join((Iterable)issues.stream().map(i -> String.format("\"%s\"", i.getKey())).collect(Collectors.toList()), (String)",")), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 not supported");
        }
    }

    public Issue getIssue(IssueServiceConfiguration issueServiceConfiguration, String issueKey) {
        return this.getIssue((JIRAConfiguration)issueServiceConfiguration, issueKey);
    }

    protected Set<String> getIssueTypes(IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        if (issue != null) {
            JIRAIssue jiraIssue = (JIRAIssue)issue;
            return Collections.singleton(jiraIssue.getIssueType());
        }
        return Collections.emptySet();
    }

    public void followLinks(JIRAConfiguration configuration, JIRAIssue seed, Set<String> linkNames, Map<String, JIRAIssue> collectedIssues) {
        try (Transaction tx = this.transactionService.start();){
            JIRASession session = this.getJIRASession(tx, configuration);
            JIRAClient client = session.getClient();
            collectedIssues.put(seed.getKey(), seed);
            seed.getLinks().stream().filter(linkedIssue -> linkNames.contains(linkedIssue.getLinkName())).filter(linkedIssue -> !collectedIssues.containsKey(linkedIssue.getKey())).map(linkedIssue -> client.getIssue(linkedIssue.getKey(), configuration)).forEach(linkedIssue -> this.followLinks(configuration, (JIRAIssue)linkedIssue, linkNames, collectedIssues));
        }
    }

    public JIRAIssue getIssue(JIRAConfiguration configuration, String key) {
        try (Transaction tx = this.transactionService.start();){
            JIRASession session = this.getJIRASession(tx, configuration);
            JIRAIssue jIRAIssue = session.getClient().getIssue(key, configuration);
            return jIRAIssue;
        }
    }

    private JIRASession getJIRASession(Transaction tx, JIRAConfiguration configuration) {
        return (JIRASession)tx.getResource(JIRASession.class, (Object)configuration.getName(), () -> this.jiraSessionFactory.create(configuration));
    }

    protected Set<String> extractJIRAIssuesFromMessage(JIRAConfiguration configuration, String message) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            Matcher matcher = JIRAConfiguration.ISSUE_PATTERN.matcher(message);
            while (matcher.find()) {
                String issueKey = matcher.group();
                if (!configuration.isIssue(issueKey)) continue;
                result.add(issueKey);
            }
        }
        return result;
    }
}

