/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira;

import java.util.List;
import net.nemerosa.ontrack.extension.jira.JIRAConfiguration;
import net.nemerosa.ontrack.extension.jira.client.JIRAClient;
import net.nemerosa.ontrack.extension.jira.tx.JIRASessionFactory;
import net.nemerosa.ontrack.extension.support.ConfigurationHealthIndicator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.stereotype.Component;

@Component
public class JIRAHealthIndicator
extends ConfigurationHealthIndicator<JIRAConfiguration> {
    private final JIRASessionFactory sessionFactory;

    @Autowired
    public JIRAHealthIndicator(ConfigurationService<JIRAConfiguration> configurationService, SecurityService securityService, HealthAggregator healthAggregator, JIRASessionFactory sessionFactory) {
        super(configurationService, securityService, healthAggregator);
        this.sessionFactory = sessionFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Health getHealth(JIRAConfiguration config) {
        try (JIRAClient client = this.sessionFactory.create(config).getClient();){
            List<String> projects = client.getProjects();
            Health health = Health.up().withDetail("projects", projects).build();
            return health;
        }
        catch (Exception ex) {
            return Health.down((Exception)ex).build();
        }
    }
}

