/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.jira.JIRAExtensionFeature;
import net.nemerosa.ontrack.extension.jira.JIRAFollowLinksProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiStrings;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JIRAFollowLinksPropertyType
extends AbstractPropertyType<JIRAFollowLinksProperty> {
    @Autowired
    public JIRAFollowLinksPropertyType(JIRAExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "JIRA Links to follow";
    }

    public String getDescription() {
        return "List of links to follow when displaying information about an issue.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, JIRAFollowLinksProperty value) {
        return Form.create().with((Field)((MultiStrings)MultiStrings.of((String)"linkNames").label("Link names")).value(value != null ? value.getLinkNames() : Collections.emptyList()));
    }

    public JsonNode forStorage(JIRAFollowLinksProperty value) {
        return JIRAFollowLinksPropertyType.format((Object)value);
    }

    public JIRAFollowLinksProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public JIRAFollowLinksProperty fromStorage(JsonNode node) {
        return (JIRAFollowLinksProperty)JIRAFollowLinksPropertyType.parse((JsonNode)node, JIRAFollowLinksProperty.class);
    }

    public String getSearchKey(JIRAFollowLinksProperty value) {
        return StringUtils.join(value.getLinkNames(), (String)" ");
    }

    public JIRAFollowLinksProperty replaceValue(JIRAFollowLinksProperty value, Function<String, String> replacementFunction) {
        return new JIRAFollowLinksProperty(value.getLinkNames().stream().map(replacementFunction).collect(Collectors.toList()));
    }
}

