/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira;

import java.net.URI;
import java.util.Collection;
import net.nemerosa.ontrack.extension.jira.JIRAConfiguration;
import net.nemerosa.ontrack.extension.jira.JIRAConfigurationService;
import net.nemerosa.ontrack.extension.jira.JIRAExtensionFeature;
import net.nemerosa.ontrack.extension.jira.tx.JIRASessionFactory;
import net.nemerosa.ontrack.extension.support.AbstractExtensionController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.ConnectionResult;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RequestMapping(value={"extension/jira"})
@RestController
public class JIRAController
extends AbstractExtensionController<JIRAExtensionFeature> {
    private final JIRAConfigurationService jiraConfigurationService;
    private final JIRASessionFactory jiraSessionFactory;
    private final SecurityService securityService;

    @Autowired
    public JIRAController(JIRAExtensionFeature feature, JIRAConfigurationService jiraConfigurationService, JIRASessionFactory jiraSessionFactory, SecurityService securityService) {
        super((ExtensionFeature)feature);
        this.jiraConfigurationService = jiraConfigurationService;
        this.jiraSessionFactory = jiraSessionFactory;
        this.securityService = securityService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resource<ExtensionFeatureDescription> getDescription() {
        return (Resource)Resource.of((Object)((JIRAExtensionFeature)this.feature).getFeatureDescription(), (URI)this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getDescription())).with("configurations", this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations()), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations"}, method={RequestMethod.GET})
    public Resources<JIRAConfiguration> getConfigurations() {
        return (Resources)((Resources)Resources.of((Collection)this.jiraConfigurationService.getConfigurations(), (URI)this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurations())).with("_create", this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationForm()))).with("_test", this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).testConfiguration(null)), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations/descriptors"}, method={RequestMethod.GET})
    public Resources<ConfigurationDescriptor> getConfigurationsDescriptors() {
        return Resources.of((Collection)this.jiraConfigurationService.getConfigurationDescriptors(), (URI)this.uri(((JIRAController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationsDescriptors()));
    }

    @RequestMapping(value={"configurations/test"}, method={RequestMethod.POST})
    public ConnectionResult testConfiguration(@RequestBody JIRAConfiguration configuration) {
        return this.jiraConfigurationService.test(configuration);
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.GET})
    public Form getConfigurationForm() {
        return JIRAConfiguration.form();
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.POST})
    public JIRAConfiguration newConfiguration(@RequestBody JIRAConfiguration configuration) {
        return (JIRAConfiguration)this.jiraConfigurationService.newConfiguration(configuration);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.GET})
    public JIRAConfiguration getConfiguration(@PathVariable String name) {
        return (JIRAConfiguration)this.jiraConfigurationService.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Ack deleteConfiguration(@PathVariable String name) {
        this.jiraConfigurationService.deleteConfiguration(name);
        return Ack.OK;
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.GET})
    public Form updateConfigurationForm(@PathVariable String name) {
        return ((JIRAConfiguration)this.jiraConfigurationService.getConfiguration(name)).asForm();
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.PUT})
    public JIRAConfiguration updateConfiguration(@PathVariable String name, @RequestBody JIRAConfiguration configuration) {
        this.jiraConfigurationService.updateConfiguration(name, configuration);
        return this.getConfiguration(name);
    }
}

