/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.jira;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;
import org.apache.commons.lang3.StringUtils;

public class JIRAConfiguration
implements UserPasswordConfiguration<JIRAConfiguration>,
IssueServiceConfiguration {
    public static final Pattern ISSUE_PATTERN = Pattern.compile("[A-Za-z][A-Za-z0-9]*\\-[0-9]+");
    private final String name;
    private final String url;
    private final String user;
    private final String password;

    public static Form form() {
        return Form.create().with((Field)Form.defaultNameField()).url().with((Field)((Text)((Text)Text.of((String)"user").label("User")).length(16)).optional()).with((Field)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).optional());
    }

    public JIRAConfiguration obfuscate() {
        return new JIRAConfiguration(this.name, this.url, this.user, "");
    }

    public Form asForm() {
        return JIRAConfiguration.form().with((Field)((Text)Form.defaultNameField().readOnly()).value((Object)this.name)).fill("url", (Object)this.url).fill("user", (Object)this.user).fill("password", (Object)"");
    }

    public JIRAConfiguration withPassword(String password) {
        return new JIRAConfiguration(this.name, this.url, this.user, password);
    }

    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor(this.name, this.name);
    }

    @JsonIgnore
    public String getServiceId() {
        return "jira";
    }

    public boolean isIssue(String token) {
        return ISSUE_PATTERN.matcher(token).matches() && !this.isIssueExcluded(token);
    }

    private boolean isIssueExcluded(String token) {
        return false;
    }

    public String getIssueURL(String key) {
        String base = this.getUrl();
        if (StringUtils.isNotBlank((CharSequence)base)) {
            return String.format("%s/browse/%s", base, key);
        }
        return key;
    }

    public JIRAConfiguration clone(String targetConfigurationName, Function<String, String> replacementFunction) {
        return new JIRAConfiguration(targetConfigurationName, replacementFunction.apply(this.url), replacementFunction.apply(this.user), this.password);
    }

    @ConstructorProperties(value={"name", "url", "user", "password"})
    public JIRAConfiguration(String name, String url, String user, String password) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JIRAConfiguration)) {
            return false;
        }
        JIRAConfiguration other = (JIRAConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JIRAConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "JIRAConfiguration(name=" + this.getName() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ")";
    }
}

