/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueExportMoreThanOneGroupException;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.support.IssueServiceUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\tH\u0007JX\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lnet/nemerosa/ontrack/extension/issues/support/IssueServiceUtils;", "", "()V", "getIssueGroups", "", "", "issueTypes", "", "groupingSpecification", "", "groupIssues", "", "Lnet/nemerosa/ontrack/extension/issues/model/Issue;", "issueServiceConfiguration", "Lnet/nemerosa/ontrack/extension/issues/model/IssueServiceConfiguration;", "issues", "request", "Lnet/nemerosa/ontrack/extension/api/model/IssueChangeLogExportRequest;", "issueTypesFn", "Ljava/util/function/BiFunction;", "ontrack-extension-issues"})
public final class IssueServiceUtils {
    public static final IssueServiceUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final Set<String> getIssueGroups(@NotNull Collection<String> issueTypes, @NotNull Map<String, ? extends Set<String>> groupingSpecification) {
        Intrinsics.checkParameterIsNotNull(issueTypes, (String)"issueTypes");
        Intrinsics.checkParameterIsNotNull(groupingSpecification, (String)"groupingSpecification");
        HashSet<String> groups = new HashSet<String>();
        for (String issueType : issueTypes) {
            Map<String, ? extends Set<String>> map = groupingSpecification;
            boolean bl = false;
            Iterator<Map.Entry<String, ? extends Set<String>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends Set<String>> entry;
                Map.Entry<String, ? extends Set<String>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                String groupName = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Set<String> groupTypes = entry2.getValue();
                if (!groupTypes.contains(issueType)) continue;
                groups.add(groupName);
            }
        }
        return groups;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, List<Issue>> groupIssues(@NotNull IssueServiceConfiguration issueServiceConfiguration, @NotNull List<? extends Issue> issues, @NotNull IssueChangeLogExportRequest request, @NotNull BiFunction<IssueServiceConfiguration, Issue, Set<String>> issueTypesFn) {
        Intrinsics.checkParameterIsNotNull((Object)issueServiceConfiguration, (String)"issueServiceConfiguration");
        Intrinsics.checkParameterIsNotNull(issues, (String)"issues");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(issueTypesFn, (String)"issueTypesFn");
        Set excludedTypes = request.getExcludedTypes();
        Map groupingSpecification = request.getGroupingSpecification();
        boolean bl = false;
        Map groupedIssues = new LinkedHashMap();
        for (String string : groupingSpecification.keySet()) {
            groupedIssues.put(string, new ArrayList());
        }
        for (Issue issue : issues) {
            Set<String> issueTypes;
            Intrinsics.checkExpressionValueIsNotNull(issueTypesFn.apply(issueServiceConfiguration, issue), (String)"issueTypesFn.apply(issue\u2026viceConfiguration, issue)");
            if (!Collections.disjoint(excludedTypes, (Collection)issueTypes)) continue;
            Set<String> issueGroups = IssueServiceUtils.getIssueGroups((Collection<String>)issueTypes, groupingSpecification);
            if (issueGroups.size() > 1) {
                throw (Throwable)((Object)new IssueExportMoreThanOneGroupException(issue.getKey(), (Collection<String>)issueGroups));
            }
            String targetGroup = issueGroups.isEmpty() ? (groupingSpecification.isEmpty() ? "" : request.getAltGroup()) : (String)CollectionsKt.first((Iterable)issueGroups);
            Object v = groupedIssues.computeIfAbsent(targetGroup, groupIssues.issueList.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"groupedIssues.computeIfA\u2026roup) { mutableListOf() }");
            List issueList2 = (List)v;
            issueList2.add(issue);
        }
        groupedIssues.entrySet().removeIf(groupIssues.1.INSTANCE);
        return groupedIssues;
    }

    private IssueServiceUtils() {
    }

    static {
        IssueServiceUtils issueServiceUtils;
        INSTANCE = issueServiceUtils = new IssueServiceUtils();
    }
}

