/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.ExtensionManager;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationIdentifier;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueServiceRegistryImpl
implements IssueServiceRegistry {
    private final ExtensionManager extensionManager;

    @Autowired
    public IssueServiceRegistryImpl(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    protected Map<String, IssueServiceExtension> getIssueServiceExtensionMap() {
        return this.extensionManager.getExtensions(IssueServiceExtension.class).stream().collect(Collectors.toMap(IssueServiceExtension::getId, x -> x));
    }

    @Override
    public Collection<IssueServiceExtension> getIssueServices() {
        return this.getIssueServiceExtensionMap().values();
    }

    @Override
    public Optional<IssueServiceExtension> getOptionalIssueService(String id) {
        return Optional.ofNullable(this.getIssueServiceExtensionMap().get(id));
    }

    @Override
    public List<IssueServiceConfigurationRepresentation> getAvailableIssueServiceConfigurations() {
        ArrayList<IssueServiceConfigurationRepresentation> issueServiceConfigurationRepresentations = new ArrayList<IssueServiceConfigurationRepresentation>();
        for (IssueServiceExtension issueServiceExtension : this.getIssueServiceExtensionMap().values()) {
            List<? extends IssueServiceConfiguration> configurationList = issueServiceExtension.getConfigurationList();
            for (IssueServiceConfiguration issueServiceConfiguration : configurationList) {
                issueServiceConfigurationRepresentations.add(IssueServiceConfigurationRepresentation.Companion.of(issueServiceExtension, issueServiceConfiguration));
            }
        }
        return issueServiceConfigurationRepresentations;
    }

    @Override
    public ConfiguredIssueService getConfiguredIssueService(String issueServiceConfigurationIdentifier) {
        IssueServiceConfigurationIdentifier identifier = IssueServiceConfigurationIdentifier.parse(issueServiceConfigurationIdentifier);
        if (identifier != null) {
            Optional<IssueServiceExtension> issueService = this.getOptionalIssueService(identifier.getServiceId());
            return issueService.map(issueServiceExtension -> new ConfiguredIssueService((IssueServiceExtension)issueServiceExtension, issueServiceExtension.getConfigurationByName(identifier.getName()))).orElse(null);
        }
        return null;
    }
}

