/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.support;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.export.ExportFormat;
import net.nemerosa.ontrack.extension.issues.export.ExportedIssues;
import net.nemerosa.ontrack.extension.issues.export.IssueExportService;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceFactory;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.support.IssueServiceUtils;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;

public abstract class AbstractIssueServiceExtension
extends AbstractExtension
implements IssueServiceExtension {
    private final String id;
    private final String name;
    private final IssueExportServiceFactory issueExportServiceFactory;

    protected AbstractIssueServiceExtension(ExtensionFeature extensionFeature, String id, String name, IssueExportServiceFactory issueExportServiceFactory) {
        super(extensionFeature);
        this.id = id;
        this.name = name;
        this.issueExportServiceFactory = issueExportServiceFactory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<ExportFormat> exportFormats(IssueServiceConfiguration issueServiceConfiguration) {
        return this.issueExportServiceFactory.getIssueExportServices().stream().map(IssueExportService::getExportFormat).collect(Collectors.toList());
    }

    @Override
    public ExportedIssues exportIssues(IssueServiceConfiguration issueServiceConfiguration, List<? extends Issue> issues, IssueChangeLogExportRequest request) {
        Map<String, List<Issue>> groupedIssues = IssueServiceUtils.groupIssues(issueServiceConfiguration, issues, request, this::getIssueTypes);
        IssueExportService exportService = this.issueExportServiceFactory.getIssueExportService(request.getFormat());
        return exportService.export(this, issueServiceConfiguration, groupedIssues);
    }

    @Override
    public String getMessageRegex(IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        String displayKey = issue.getDisplayKey();
        return "(?:\\s|^)(" + displayKey + ")(?:[^\\d]|$)";
    }

    protected abstract Set<String> getIssueTypes(IssueServiceConfiguration var1, Issue var2);
}

